/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.petite.BeanDefinition;
import jodd.petite.CtorInjectionPoint;
import jodd.petite.InitMethodPoint;
import jodd.petite.InjectionPointFactory;
import jodd.petite.MethodInjectionPoint;
import jodd.petite.PetiteConfig;
import jodd.petite.PetiteException;
import jodd.petite.PetiteResolvers;
import jodd.petite.PetiteUtil;
import jodd.petite.PropertyInjectionPoint;
import jodd.petite.SetInjectionPoint;
import jodd.petite.WiringMode;
import jodd.petite.scope.DefaultScope;
import jodd.petite.scope.Scope;
import jodd.util.ReflectUtil;
import jodd.util.StringPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PetiteBeans {
    private static final Logger log = LoggerFactory.getLogger(PetiteBeans.class);
    protected final Map<String, BeanDefinition> beans = new HashMap<String, BeanDefinition>();
    protected final Map<Class<? extends Scope>, Scope> scopes = new HashMap<Class<? extends Scope>, Scope>();
    protected final Map<Class, String[]> beanCollections = new HashMap<Class, String[]>();
    protected final PetiteConfig petiteConfig;
    protected final InjectionPointFactory injectionPointFactory;
    protected final PetiteResolvers petiteResolvers;

    protected PetiteBeans(PetiteConfig petiteConfig) {
        this.petiteConfig = petiteConfig;
        this.injectionPointFactory = new InjectionPointFactory(petiteConfig);
        this.petiteResolvers = new PetiteResolvers(this.injectionPointFactory);
    }

    public PetiteResolvers getResolvers() {
        return this.petiteResolvers;
    }

    public PetiteConfig getConfig() {
        return this.petiteConfig;
    }

    protected Scope resolveScope(Class<? extends Scope> scopeType) {
        Scope scope = this.scopes.get(scopeType);
        if (scope == null) {
            try {
                scope = scopeType.newInstance();
                this.registerScope(scopeType, scope);
                this.scopes.put(scopeType, scope);
            }
            catch (Exception ex) {
                throw new PetiteException("Unable to create Petite scope: '" + scopeType.getName(), ex);
            }
        }
        return scope;
    }

    public void registerScope(Class<? extends Scope> scopeType, Scope scope) {
        this.scopes.put(scopeType, scope);
    }

    protected BeanDefinition lookupBeanDefinition(String name) {
        return this.beans.get(name);
    }

    protected BeanDefinition lookupBeanDefinition(String[] names) {
        for (String name : names) {
            BeanDefinition beanDefinition = this.lookupBeanDefinition(name);
            if (beanDefinition == null) continue;
            return beanDefinition;
        }
        return null;
    }

    protected BeanDefinition lookupExistingBeanDefinition(String name) {
        BeanDefinition beanDefinition = this.lookupBeanDefinition(name);
        if (beanDefinition == null) {
            throw new PetiteException("Bean: '" + name + "' not registered.");
        }
        return beanDefinition;
    }

    public boolean isBeanNameRegistered(String name) {
        return this.lookupBeanDefinition(name) != null;
    }

    public String resolveBeanName(Class type) {
        return PetiteUtil.resolveBeanName(type, this.petiteConfig.getUseFullTypeNames());
    }

    protected BeanDefinition registerPetiteBean(String name, Class type, Class<? extends Scope> scopeType, WiringMode wiringMode) {
        BeanDefinition existing;
        if (name == null) {
            name = PetiteUtil.resolveBeanName(type, this.petiteConfig.getUseFullTypeNames());
        }
        if (wiringMode == null) {
            wiringMode = PetiteUtil.resolveBeanWiringMode(type);
        }
        if (wiringMode == WiringMode.DEFAULT) {
            wiringMode = this.petiteConfig.getDefaultWiringMode();
        }
        if (scopeType == null) {
            scopeType = PetiteUtil.resolveBeanScopeType(type);
        }
        if (scopeType == DefaultScope.class) {
            scopeType = this.petiteConfig.getDefaultScope();
        }
        if ((existing = this.removeBeanDefinition(name)) != null && this.petiteConfig.getDetectDuplicatedBeanNames()) {
            throw new PetiteException("Duplicated bean name detected while registering class '" + type.getName() + "'. Petite bean class '" + existing.type.getName() + "' is already registered with the name '" + name + "'.");
        }
        if (log.isDebugEnabled()) {
            log.debug("Registering bean: " + name + " of type: " + type.getSimpleName() + " in: " + scopeType.getSimpleName() + " using wiring mode: " + wiringMode.toString());
        }
        if (type != null && type.isInterface()) {
            throw new PetiteException("Unable to register interface: " + type.getName());
        }
        Scope scope = this.resolveScope(scopeType);
        BeanDefinition beanDefinition = new BeanDefinition(name, type, scope, wiringMode);
        this.beans.put(name, beanDefinition);
        return beanDefinition;
    }

    protected void definePetiteBean(String name, Class type, Class<? extends Scope> scopeType, WiringMode wiringMode) {
        BeanDefinition def = this.registerPetiteBean(name, type, scopeType, wiringMode);
        def.ctor = this.resolveCtorInjectionPoint(type);
        def.properties = PropertyInjectionPoint.EMPTY;
        def.methods = MethodInjectionPoint.EMPTY;
        def.initMethods = InitMethodPoint.EMPTY;
    }

    protected BeanDefinition removeBeanDefinition(String name) {
        BeanDefinition bd = this.beans.remove(name);
        if (bd == null) {
            return null;
        }
        this.petiteResolvers.getCtorResolver().remove(bd.type);
        this.petiteResolvers.getPropertyResolver().remove(bd.type);
        this.petiteResolvers.getMethodResolver().remove(bd.type);
        this.petiteResolvers.getInitMethodResolver().remove(bd.type);
        bd.scopeRemove();
        return bd;
    }

    protected String[] resolveBeanNamesForType(Class type) {
        String[] beanNames = this.beanCollections.get(type);
        if (beanNames != null) {
            return beanNames;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, BeanDefinition> entry : this.beans.entrySet()) {
            BeanDefinition beanDefinition = entry.getValue();
            if (!ReflectUtil.isSubclass((Class)beanDefinition.type, (Class)type)) continue;
            String beanName = entry.getKey();
            list.add(beanName);
        }
        beanNames = list.isEmpty() ? StringPool.EMPTY_ARRAY : list.toArray(new String[list.size()]);
        this.beanCollections.put(type, beanNames);
        return beanNames;
    }

    protected void registerPetiteCtorInjectionPoint(String beanName, Class[] paramTypes, String[] references) {
        BeanDefinition beanDefinition = this.lookupExistingBeanDefinition(beanName);
        String[][] ref = PetiteUtil.convertRefToReferences(references);
        beanDefinition.ctor = this.defineCtorInjectionPoint(beanDefinition.type, paramTypes, ref);
    }

    private CtorInjectionPoint defineCtorInjectionPoint(Class type, Class[] paramTypes, String[][] references) {
        ClassDescriptor cd = ClassIntrospector.lookup((Class)type);
        Constructor constructor = null;
        if (paramTypes == null) {
            Constructor[] ctors = cd.getAllCtors(true);
            if (ctors.length > 0) {
                if (ctors.length > 1) {
                    throw new PetiteException(ctors.length + " suitable constructor found as injection point for: " + type.getName());
                }
                constructor = ctors[0];
            }
        } else {
            constructor = cd.getCtor(paramTypes, true);
        }
        if (constructor == null) {
            throw new PetiteException("Constructor '" + type.getName() + "()' not found.");
        }
        return this.injectionPointFactory.createCtorInjectionPoint(constructor, references);
    }

    protected void registerPetitePropertyInjectionPoint(String beanName, String property, String reference) {
        String[] stringArray;
        BeanDefinition beanDefinition = this.lookupExistingBeanDefinition(beanName);
        Class clazz = beanDefinition.type;
        if (reference == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = reference;
        }
        PropertyInjectionPoint pip = this.definePropertyInjectionPoint(clazz, property, stringArray);
        beanDefinition.addPropertyInjectionPoint(pip);
    }

    private PropertyInjectionPoint definePropertyInjectionPoint(Class type, String property, String[] references) {
        ClassDescriptor cd = ClassIntrospector.lookup((Class)type);
        Field field = cd.getField(property, true);
        if (field == null) {
            throw new PetiteException("Property '" + type.getName() + '#' + property + "' doesn't exist");
        }
        return this.injectionPointFactory.createPropertyInjectionPoint(field, references);
    }

    protected void registerPetiteSetInjectionPoint(String beanName, String property) {
        BeanDefinition beanDefinition = this.lookupExistingBeanDefinition(beanName);
        SetInjectionPoint sip = this.defineSetInjectionPoint(beanDefinition.type, property);
        beanDefinition.addSetInjectionPoint(sip);
    }

    private SetInjectionPoint defineSetInjectionPoint(Class type, String property) {
        ClassDescriptor cd = ClassIntrospector.lookup((Class)type);
        Field field = cd.getField(property, true);
        if (field == null) {
            throw new PetiteException("Property '" + type.getName() + '#' + property + "' doesn't exist");
        }
        return this.injectionPointFactory.createSetInjectionPoint(field);
    }

    protected void registerPetiteMethodInjectionPoint(String beanName, String methodName, Class[] arguments, String[] references) {
        BeanDefinition beanDefinition = this.lookupExistingBeanDefinition(beanName);
        String[][] ref = PetiteUtil.convertRefToReferences(references);
        MethodInjectionPoint mip = this.defineMethodInjectionPoint(beanDefinition.type, methodName, arguments, ref);
        beanDefinition.addMethodInjectionPoint(mip);
    }

    private MethodInjectionPoint defineMethodInjectionPoint(Class type, String methodName, Class[] paramTypes, String[][] references) {
        ClassDescriptor cd = ClassIntrospector.lookup((Class)type);
        Method method = null;
        if (paramTypes == null) {
            Method[] methods = cd.getAllMethods(methodName, true);
            if (methods.length > 0) {
                if (methods.length > 1) {
                    throw new PetiteException(methods.length + " suitable methods found as injection points for '" + type.getName() + '#' + methodName + "()'.");
                }
                method = methods[0];
            }
        } else {
            method = cd.getMethod(methodName, paramTypes, true);
        }
        if (method == null) {
            throw new PetiteException("Method '" + type.getName() + '#' + methodName + "()' not found.");
        }
        return this.injectionPointFactory.createMethodInjectionPoint(method, references);
    }

    protected void registerPetiteInitMethods(String beanName, String[] beforeMethodNames, String[] afterMethodNames) {
        BeanDefinition beanDefinition = this.lookupExistingBeanDefinition(beanName);
        InitMethodPoint[] methods = this.defineInitMethods(beanDefinition.type, beforeMethodNames, afterMethodNames);
        beanDefinition.addInitMethodPoints(methods);
    }

    private InitMethodPoint[] defineInitMethods(Class type, String[] beforeMethodNames, String[] afterMethodNames) {
        int i;
        ClassDescriptor cd = ClassIntrospector.lookup((Class)type);
        if (beforeMethodNames == null) {
            beforeMethodNames = StringPool.EMPTY_ARRAY;
        }
        if (afterMethodNames == null) {
            afterMethodNames = StringPool.EMPTY_ARRAY;
        }
        int total = beforeMethodNames.length + afterMethodNames.length;
        InitMethodPoint[] methods = new InitMethodPoint[total];
        for (i = 0; i < beforeMethodNames.length; ++i) {
            Method m = cd.getMethod(beforeMethodNames[i], ReflectUtil.NO_PARAMETERS, true);
            if (m == null) {
                throw new PetiteException("Init method '" + type.getName() + '#' + beforeMethodNames[i] + "()' not found.");
            }
            methods[i] = new InitMethodPoint(m, i, true);
        }
        for (int j = 0; j < afterMethodNames.length; ++j) {
            Method m = cd.getMethod(afterMethodNames[j], ReflectUtil.NO_PARAMETERS, true);
            if (m == null) {
                throw new PetiteException("Init method '" + type.getName() + '#' + afterMethodNames[j] + "()' not found.");
            }
            methods[i + j] = new InitMethodPoint(m, i + j, true);
        }
        return methods;
    }

    public int getTotalBeans() {
        return this.beans.size();
    }

    public int getTotalScopes() {
        return this.scopes.size();
    }

    public Iterator<BeanDefinition> beansIterator() {
        return this.beans.values().iterator();
    }

    protected CtorInjectionPoint resolveCtorInjectionPoint(Class type) {
        return this.petiteResolvers.getCtorResolver().resolve(type);
    }

    protected CtorInjectionPoint resolveDefaultCtorInjectionPoint(Class type) {
        return this.petiteResolvers.getCtorResolver().resolveDefault(type);
    }

    protected PropertyInjectionPoint[] resolvePropertyInjectionPoint(Class type, boolean autowire) {
        return this.petiteResolvers.getPropertyResolver().resolve(type, autowire);
    }

    protected SetInjectionPoint[] resolveCollectionInjectionPoint(Class type, boolean autowire) {
        return this.petiteResolvers.getSetResolver().resolve(type, autowire);
    }

    protected MethodInjectionPoint[] resolveMethodInjectionPoint(Class type) {
        return this.petiteResolvers.getMethodResolver().resolve(type);
    }

    protected InitMethodPoint[] resolveInitMethods(Object bean) {
        return this.petiteResolvers.getInitMethodResolver().resolve(bean);
    }

    public void defineParameter(String name, Object value) {
        this.petiteResolvers.getParamResolver().put(name, value);
    }

    public Object getParameter(String name) {
        return this.petiteResolvers.getParamResolver().get(name);
    }

    protected String[] resolveBeanParams(String name, boolean resolveReferenceParams) {
        return this.petiteResolvers.getParamResolver().resolve(name, resolveReferenceParams);
    }
}

