/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite.resolver;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.petite.InjectionPointFactory;
import jodd.petite.MethodInjectionPoint;
import jodd.petite.PetiteUtil;
import jodd.petite.meta.PetiteInject;

public class MethodResolver {
    protected final Map<Class, MethodInjectionPoint[]> methodRefs = new HashMap<Class, MethodInjectionPoint[]>();
    protected final InjectionPointFactory injectionPointFactory;

    public MethodResolver(InjectionPointFactory injectionPointFactory) {
        this.injectionPointFactory = injectionPointFactory;
    }

    public MethodInjectionPoint[] resolve(Class type) {
        Method[] allMethods;
        MethodInjectionPoint[] methods = this.methodRefs.get(type);
        if (methods != null) {
            return methods;
        }
        ClassDescriptor cd = ClassIntrospector.lookup((Class)type);
        ArrayList<MethodInjectionPoint> list = new ArrayList<MethodInjectionPoint>();
        for (Method method : allMethods = cd.getAllMethods(true)) {
            PetiteInject ref = method.getAnnotation(PetiteInject.class);
            if (ref == null) continue;
            String[][] references = PetiteUtil.convertAnnValueToReferences(ref.value());
            list.add(this.injectionPointFactory.createMethodInjectionPoint(method, references));
        }
        methods = list.isEmpty() ? MethodInjectionPoint.EMPTY : list.toArray(new MethodInjectionPoint[list.size()]);
        this.methodRefs.put(type, methods);
        return methods;
    }

    public void remove(Class type) {
        this.methodRefs.remove(type);
    }
}

