/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite.scope;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import jodd.petite.PetiteException;
import jodd.petite.scope.Scope;
import jodd.petite.scope.SingletonScope;
import jodd.servlet.HttpSessionListenerBroadcaster;
import jodd.servlet.RequestContextListener;

public class SessionScope
implements Scope {
    protected Map<String, Map<String, Object>> sessionInstances = new WeakHashMap<String, Map<String, Object>>();
    protected final HttpSessionListenerBroadcaster sessionListeners = HttpSessionListenerBroadcaster.getInstance();

    public SessionScope() {
        if (this.sessionListeners == null) {
            throw new PetiteException(HttpSessionListenerBroadcaster.class.getSimpleName() + " not available.");
        }
        this.sessionListeners.registerListener(new HttpSessionListener(){

            public void sessionCreated(HttpSessionEvent httpSessionEvent) {
                SessionScope.this.sessionInstances.put(httpSessionEvent.getSession().getId(), new HashMap());
            }

            public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
                SessionScope.this.sessionInstances.remove(httpSessionEvent.getSession().getId());
            }
        });
    }

    public Object lookup(String name) {
        String sessionId = this.getHttpSessionId();
        Map<String, Object> map = this.sessionInstances.get(sessionId);
        if (map == null) {
            return null;
        }
        return map.get(name);
    }

    public void register(String name, Object bean) {
        String sessionId = this.getHttpSessionId();
        Map<String, Object> map = this.sessionInstances.get(sessionId);
        if (map == null) {
            map = new HashMap<String, Object>();
            this.sessionInstances.put(sessionId, map);
        }
        map.put(name, bean);
    }

    public void remove(String name) {
        for (Map<String, Object> map : this.sessionInstances.values()) {
            map.remove(name);
        }
    }

    public boolean accept(Scope referenceScope) {
        Class<?> refScopeType = referenceScope.getClass();
        if (refScopeType == SingletonScope.class) {
            return true;
        }
        if (refScopeType == SessionScope.class) {
            return true;
        }
        return true;
    }

    protected String getHttpSessionId() {
        HttpServletRequest request = RequestContextListener.getRequest();
        if (request == null) {
            throw new PetiteException("No HTTP request bound to the current thread. Maybe RequestContextListener is not available?");
        }
        return request.getSession().getId();
    }
}

