/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jodd.JoddPetite;
import jodd.bean.BeanUtil;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.petite.BeanDefinition;
import jodd.petite.InitMethodPoint;
import jodd.petite.MethodInjectionPoint;
import jodd.petite.PetiteBeans;
import jodd.petite.PetiteConfig;
import jodd.petite.PetiteException;
import jodd.petite.PropertyInjectionPoint;
import jodd.petite.ProviderDefinition;
import jodd.petite.ScopedProxyManager;
import jodd.petite.SetInjectionPoint;
import jodd.petite.WiringMode;
import jodd.petite.meta.InitMethodInvocationStrategy;
import jodd.petite.scope.Scope;
import jodd.petite.scope.SingletonScope;
import jodd.typeconverter.Convert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PetiteContainer
extends PetiteBeans {
    private static final Logger log = LoggerFactory.getLogger(PetiteContainer.class);
    public static final String PETITE_CONTAINER_REF_NAME = "petiteContainer";
    protected final ScopedProxyManager scopedProxyManager = JoddPetite.useProxetta ? new ScopedProxyManager() : null;

    public PetiteContainer() {
        this(new PetiteConfig());
    }

    public PetiteContainer(PetiteConfig config) {
        super(config);
        if (log.isDebugEnabled()) {
            log.debug("Petite container created.");
            if (JoddPetite.useProxetta) {
                log.debug("Petite proxy features enabled.");
            } else {
                log.debug("Petite proxy features not available.");
            }
        }
    }

    protected Object newBeanInstance(BeanDefinition def, Map<String, Object> acquiredBeans) {
        Object bean;
        if (def.ctor == null) {
            def.ctor = this.petiteResolvers.resolveCtorInjectionPoint(def.type);
        }
        if (def.name != null) {
            acquiredBeans.put(def.name, Void.TYPE);
        }
        int paramNo = def.ctor.references.length;
        Object[] args = new Object[paramNo];
        if (def.wiringMode != WiringMode.NONE) {
            for (int i = 0; i < paramNo; ++i) {
                args[i] = this.getBean(def.ctor.references[i], acquiredBeans);
                if (args[i] != null || def.wiringMode != WiringMode.STRICT) continue;
                throw new PetiteException("Wiring constructor failed. References '" + Convert.toString((Object)def.ctor.references[i]) + "' not found for constructor: " + def.ctor.constructor);
            }
        }
        try {
            bean = def.ctor.constructor.newInstance(args);
        }
        catch (Exception ex) {
            throw new PetiteException("Failed to create new bean instance '" + def.type.getName() + "' using constructor: " + def.ctor.constructor, ex);
        }
        if (def.name != null) {
            acquiredBeans.put(def.name, bean);
        }
        return bean;
    }

    protected void wireBean(Object bean, BeanDefinition def, Map<String, Object> acquiredBeans) {
        if (def.wiringMode == WiringMode.NONE) {
            return;
        }
        this.wireFields(bean, def, acquiredBeans);
        this.wireMethods(bean, def, acquiredBeans);
    }

    protected void wireFields(Object bean, BeanDefinition def, Map<String, Object> acquiredBeans) {
        if (def.properties == null) {
            def.properties = this.petiteResolvers.resolvePropertyInjectionPoint(def.type, def.wiringMode == WiringMode.AUTOWIRE);
        }
        boolean mixing = this.petiteConfig.wireScopedProxy || this.petiteConfig.detectMixedScopes;
        for (PropertyInjectionPoint pip : def.properties) {
            BeanDefinition refBeanDefinition;
            String[] refNames = pip.references;
            Object value = null;
            if (mixing && (refBeanDefinition = this.lookupBeanDefinitions(refNames)) != null) {
                value = this.scopedProxyManager.lookupValue(this, def, refBeanDefinition);
            }
            if (value == null) {
                value = this.getBean(refNames, acquiredBeans);
            }
            if (value == null) {
                if (def.wiringMode != WiringMode.STRICT) continue;
                throw new PetiteException("Wiring failed. Beans references: '" + Convert.toString((Object)refNames) + "' not found for property: " + def.type.getName() + '#' + pip.field.getName());
            }
            BeanUtil.setDeclaredProperty((Object)bean, (String)pip.field.getName(), (Object)value);
        }
        if (def.sets == null) {
            def.sets = this.petiteResolvers.resolveSetInjectionPoint(def.type, def.wiringMode == WiringMode.AUTOWIRE);
        }
        for (SetInjectionPoint sip : def.sets) {
            String[] beanNames = this.resolveBeanNamesForType(sip.targetClass);
            Collection beans = sip.createSet(beanNames.length);
            for (String beanName : beanNames) {
                if (beanName.equals(def.name)) continue;
                Object value = this.getBean(beanName, acquiredBeans);
                beans.add(value);
            }
            BeanUtil.setDeclaredProperty((Object)bean, (String)sip.field.getName(), beans);
        }
    }

    protected void wireMethods(Object bean, BeanDefinition def, Map<String, Object> acquiredBeans) {
        if (def.methods == null) {
            def.methods = this.petiteResolvers.resolveMethodInjectionPoint(def.type);
        }
        for (MethodInjectionPoint methodRef : def.methods) {
            String[][] refNames = methodRef.references;
            Object[] args = new Object[refNames.length];
            for (int i = 0; i < refNames.length; ++i) {
                BeanDefinition refBeanDefinition;
                boolean mixing;
                String[] refName = refNames[i];
                Object value = null;
                boolean bl = mixing = this.petiteConfig.wireScopedProxy || this.petiteConfig.detectMixedScopes;
                if (mixing && (refBeanDefinition = this.lookupBeanDefinitions(refName)) != null) {
                    value = this.scopedProxyManager.lookupValue(this, def, refBeanDefinition);
                }
                if (value == null) {
                    value = this.getBean(refName, acquiredBeans);
                }
                args[i] = value;
                if (value != null || def.wiringMode != WiringMode.STRICT) continue;
                throw new PetiteException("Wiring failed. Beans references: '" + Convert.toString((Object)refName) + "' not found for method: " + def.type.getName() + '#' + methodRef.method.getName());
            }
            try {
                methodRef.method.invoke(bean, args);
            }
            catch (Exception ex) {
                throw new PetiteException(ex);
            }
        }
    }

    protected void invokeInitMethods(Object bean, BeanDefinition def, InitMethodInvocationStrategy invocationStrategy) {
        if (def.initMethods == null) {
            def.initMethods = this.petiteResolvers.resolveInitMethodPoint(bean);
        }
        if (def.destroyMethods == null) {
            def.destroyMethods = this.petiteResolvers.resolveDestroyMethodPoint(bean);
        }
        for (InitMethodPoint initMethod : def.initMethods) {
            if (invocationStrategy != initMethod.invocationStrategy) continue;
            try {
                initMethod.method.invoke(bean, new Object[0]);
            }
            catch (Exception ex) {
                throw new PetiteException("Invalid init method: " + initMethod, ex);
            }
        }
    }

    protected void injectParams(Object bean, BeanDefinition def) {
        if (def.name == null) {
            return;
        }
        if (def.params == null) {
            def.params = this.resolveBeanParams(def.name, this.petiteConfig.getResolveReferenceParameters());
        }
        int len = def.name.length() + 1;
        for (String param : def.params) {
            Object value = this.getParameter(param);
            String destination = param.substring(len);
            try {
                BeanUtil.setDeclaredProperty((Object)bean, (String)destination, (Object)value);
            }
            catch (Exception ex) {
                throw new PetiteException("Unable to set parameter: '" + param + "' to bean: " + def.name, ex);
            }
        }
    }

    public <T> T getBean(Class<T> type) {
        String name = this.resolveBeanName(type);
        return (T)this.getBean(name);
    }

    public Object getBean(String name) {
        return this.getBean(name, new HashMap<String, Object>());
    }

    protected Object getBean(String[] names, Map<String, Object> acquiredBeans) {
        for (String name : names) {
            Object bean;
            if (name == null || (bean = this.getBean(name, acquiredBeans)) == null) continue;
            return bean;
        }
        return null;
    }

    protected Object getBean(String name, Map<String, Object> acquiredBeans) {
        Object bean = acquiredBeans.get(name);
        if (bean != null) {
            if (bean == Void.TYPE) {
                throw new PetiteException("Cycle dependencies on constructor injection detected!");
            }
            return bean;
        }
        BeanDefinition def = this.lookupBeanDefinition(name);
        if (def == null) {
            ProviderDefinition providerDefinition = (ProviderDefinition)this.providers.get(name);
            if (providerDefinition != null) {
                return this.invokeProvider(providerDefinition);
            }
            return null;
        }
        bean = def.scopeLookup();
        if (bean == null) {
            bean = this.newBeanInstance(def, acquiredBeans);
            this.wireBeanInjectParamsAndInvokeInitMethods(def, bean, acquiredBeans);
            def.scopeRegister(bean);
        }
        return bean;
    }

    protected void wireBeanInjectParamsAndInvokeInitMethods(BeanDefinition def, Object bean, Map<String, Object> acquiredBeans) {
        this.invokeInitMethods(bean, def, InitMethodInvocationStrategy.POST_CONSTRUCT);
        this.wireBean(bean, def, acquiredBeans);
        this.invokeInitMethods(bean, def, InitMethodInvocationStrategy.POST_DEFINE);
        this.injectParams(bean, def);
        this.invokeInitMethods(bean, def, InitMethodInvocationStrategy.POST_INITIALIZE);
    }

    public void wire(Object bean) {
        this.wire(bean, null);
    }

    public void wire(Object bean, WiringMode wiringMode) {
        wiringMode = this.petiteConfig.resolveWiringMode(wiringMode);
        BeanDefinition def = new BeanDefinition(null, bean.getClass(), null, wiringMode);
        HashMap<String, Object> acquiredBeans = new HashMap<String, Object>();
        this.wireBeanInjectParamsAndInvokeInitMethods(def, bean, acquiredBeans);
    }

    public <E> E createBean(Class<E> type) {
        return this.createBean(type, null);
    }

    public <E> E createBean(Class<E> type, WiringMode wiringMode) {
        wiringMode = this.petiteConfig.resolveWiringMode(wiringMode);
        BeanDefinition def = new BeanDefinition(null, type, null, wiringMode);
        HashMap<String, Object> acquiredBeans = new HashMap<String, Object>();
        Object bean = this.newBeanInstance(def, acquiredBeans);
        this.wireBeanInjectParamsAndInvokeInitMethods(def, bean, acquiredBeans);
        return (E)bean;
    }

    protected Object invokeProvider(ProviderDefinition provider) {
        if (provider.method != null) {
            Object bean = provider.beanName != null ? this.getBean(provider.beanName) : null;
            try {
                return provider.method.invoke(bean, new Object[0]);
            }
            catch (Exception ex) {
                throw new PetiteException("Invalid provider method: " + provider.method.getName(), ex);
            }
        }
        throw new PetiteException("Invalid provider");
    }

    public void addBean(String name, Object bean) {
        this.addBean(name, bean, null);
    }

    public void addBean(String name, Object bean, WiringMode wiringMode) {
        wiringMode = this.petiteConfig.resolveWiringMode(wiringMode);
        this.registerPetiteBean(bean.getClass(), name, SingletonScope.class, wiringMode, false);
        BeanDefinition def = this.lookupExistingBeanDefinition(name);
        HashMap<String, Object> acquiredBeans = new HashMap<String, Object>();
        acquiredBeans.put(name, bean);
        this.wireBeanInjectParamsAndInvokeInitMethods(def, bean, acquiredBeans);
        def.scopeRegister(bean);
    }

    public void addSelf(String name) {
        this.addBean(name, this, WiringMode.NONE);
    }

    public void addSelf() {
        this.addBean(PETITE_CONTAINER_REF_NAME, this, WiringMode.NONE);
    }

    public void setBeanProperty(String name, Object value) {
        String beanName;
        Object bean = null;
        int ndx = name.length();
        while ((ndx = name.lastIndexOf(46, ndx)) != -1 && (bean = this.getBean(beanName = name.substring(0, ndx))) == null) {
            --ndx;
        }
        if (bean == null) {
            throw new PetiteException("Invalid bean property: " + name);
        }
        try {
            BeanUtil.setDeclaredProperty((Object)bean, (String)name.substring(ndx + 1), (Object)value);
        }
        catch (Exception ex) {
            throw new PetiteException("Invalid bean property: " + name, ex);
        }
    }

    public Object getBeanProperty(String name) {
        int ndx = name.indexOf(46);
        if (ndx == -1) {
            throw new PetiteException("Only bean name is specified, missing property name: " + name);
        }
        String beanName = name.substring(0, ndx);
        Object bean = this.getBean(beanName);
        if (bean == null) {
            throw new PetiteException("Bean doesn't exist: " + name);
        }
        try {
            return BeanUtil.getDeclaredProperty((Object)bean, (String)name.substring(ndx + 1));
        }
        catch (Exception ex) {
            throw new PetiteException("Invalid bean property: " + name, ex);
        }
    }

    public void shutdown() {
        for (Scope scope : this.scopes.values()) {
            scope.shutdown();
        }
    }
}

