/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite;

import jodd.JoddPetite;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.petite.PetiteException;
import jodd.petite.PetiteReference;
import jodd.petite.WiringMode;

public class PetiteConfig {
    private static final Logger log = LoggerFactory.getLogger(PetiteConfig.class);
    protected WiringMode defaultWiringMode = WiringMode.STRICT;
    protected boolean detectDuplicatedBeanNames = false;
    protected boolean resolveReferenceParameters = true;
    protected boolean useFullTypeNames = false;
    protected PetiteReference[] lookupReferences = new PetiteReference[]{PetiteReference.NAME, PetiteReference.TYPE_SHORT_NAME, PetiteReference.TYPE_FULL_NAME};
    protected boolean useParamo = JoddPetite.useProxetta;
    protected boolean wireScopedProxy = false;
    protected boolean detectMixedScopes = false;

    public WiringMode getDefaultWiringMode() {
        return this.defaultWiringMode;
    }

    public void setDefaultWiringMode(WiringMode defaultWiringMode) {
        if (defaultWiringMode == null || defaultWiringMode == WiringMode.DEFAULT) {
            throw new PetiteException("Invalid default wiring mode: " + (Object)((Object)defaultWiringMode));
        }
        this.defaultWiringMode = defaultWiringMode;
    }

    protected WiringMode resolveWiringMode(WiringMode wiringMode) {
        if (wiringMode == null || wiringMode == WiringMode.DEFAULT) {
            wiringMode = this.defaultWiringMode;
        }
        return wiringMode;
    }

    public boolean getDetectDuplicatedBeanNames() {
        return this.detectDuplicatedBeanNames;
    }

    public void setDetectDuplicatedBeanNames(boolean detectDuplicatedBeanNames) {
        this.detectDuplicatedBeanNames = detectDuplicatedBeanNames;
    }

    public boolean getResolveReferenceParameters() {
        return this.resolveReferenceParameters;
    }

    public void setResolveReferenceParameters(boolean resolveReferenceParameters) {
        this.resolveReferenceParameters = resolveReferenceParameters;
    }

    public boolean getUseFullTypeNames() {
        return this.useFullTypeNames;
    }

    public void setUseFullTypeNames(boolean useFullTypeNames) {
        this.useFullTypeNames = useFullTypeNames;
    }

    public PetiteReference[] getLookupReferences() {
        return this.lookupReferences;
    }

    public void setLookupReferences(PetiteReference ... lookupReferences) {
        this.lookupReferences = lookupReferences;
    }

    public boolean getUseParamo() {
        return this.useParamo;
    }

    public void setUseParamo(boolean useParamo) {
        if (!JoddPetite.useProxetta) {
            log.warn("Feature not available without Proxetta");
            return;
        }
        this.useParamo = useParamo;
    }

    public boolean isWireScopedProxy() {
        return this.wireScopedProxy;
    }

    public void setWireScopedProxy(boolean wireScopedProxy) {
        if (!JoddPetite.useProxetta) {
            log.warn("Feature not available without Proxetta");
            return;
        }
        this.wireScopedProxy = wireScopedProxy;
    }

    public boolean isDetectMixedScopes() {
        return this.detectMixedScopes;
    }

    public void setDetectMixedScopes(boolean detectMixedScopes) {
        if (!JoddPetite.useProxetta) {
            log.warn("Feature not available without Proxetta");
            return;
        }
        this.detectMixedScopes = detectMixedScopes;
    }
}

