/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite.resolver;

import java.lang.reflect.Method;
import java.util.ArrayList;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.introspector.MethodDescriptor;
import jodd.petite.InjectionPointFactory;
import jodd.petite.MethodInjectionPoint;
import jodd.petite.PetiteUtil;
import jodd.petite.meta.PetiteInject;

public class MethodResolver {
    protected final InjectionPointFactory injectionPointFactory;

    public MethodResolver(InjectionPointFactory injectionPointFactory) {
        this.injectionPointFactory = injectionPointFactory;
    }

    public MethodInjectionPoint[] resolve(Class type) {
        MethodDescriptor[] allMethods;
        ClassDescriptor cd = ClassIntrospector.lookup((Class)type);
        ArrayList<MethodInjectionPoint> list = new ArrayList<MethodInjectionPoint>();
        for (MethodDescriptor methodDescriptor : allMethods = cd.getAllMethodDescriptors()) {
            Method method = methodDescriptor.getMethod();
            PetiteInject ref = method.getAnnotation(PetiteInject.class);
            if (ref == null) continue;
            String[][] references = PetiteUtil.convertAnnValueToReferences(ref.value());
            list.add(this.injectionPointFactory.createMethodInjectionPoint(method, references));
        }
        MethodInjectionPoint[] methods = list.isEmpty() ? MethodInjectionPoint.EMPTY : list.toArray(new MethodInjectionPoint[list.size()]);
        return methods;
    }
}

