/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite.resolver;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.introspector.FieldDescriptor;
import jodd.petite.InjectionPointFactory;
import jodd.petite.PropertyInjectionPoint;
import jodd.petite.meta.PetiteInject;
import jodd.util.ReflectUtil;

public class PropertyResolver {
    protected final InjectionPointFactory injectionPointFactory;

    public PropertyResolver(InjectionPointFactory injectionPointFactory) {
        this.injectionPointFactory = injectionPointFactory;
    }

    public PropertyInjectionPoint[] resolve(Class type, boolean autowire) {
        FieldDescriptor[] allFields;
        ClassDescriptor cd = ClassIntrospector.lookup((Class)type);
        ArrayList<PropertyInjectionPoint> list = new ArrayList<PropertyInjectionPoint>();
        for (FieldDescriptor fieldDescriptor : allFields = cd.getAllFieldDescriptors()) {
            String name;
            Class<?> fieldType;
            Field field = fieldDescriptor.getField();
            PetiteInject ref = field.getAnnotation(PetiteInject.class);
            if (!autowire && ref == null || (fieldType = field.getType()) == Collection.class || ReflectUtil.isSubclass(fieldType, Collection.class)) continue;
            String[] refName = null;
            if (ref != null && (name = ref.value().trim()).length() != 0) {
                refName = new String[]{name};
            }
            list.add(this.injectionPointFactory.createPropertyInjectionPoint(field, refName));
        }
        PropertyInjectionPoint[] fields = list.isEmpty() ? PropertyInjectionPoint.EMPTY : list.toArray(new PropertyInjectionPoint[list.size()]);
        return fields;
    }
}

