/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite;

import jodd.petite.PetiteContainer;
import jodd.petite.PetiteException;
import jodd.petite.WiringMode;
import jodd.petite.meta.InitMethodInvocationStrategy;
import jodd.petite.scope.Scope;
import jodd.util.ReflectUtil;

public class PetiteRegistry {
    private final PetiteContainer petiteContainer;

    public static PetiteRegistry petite(PetiteContainer petiteContainer) {
        return new PetiteRegistry(petiteContainer);
    }

    public PetiteRegistry(PetiteContainer petiteContainer) {
        this.petiteContainer = petiteContainer;
    }

    public BeanRegister bean(Class beanType) {
        return new BeanRegister(beanType);
    }

    public BeanWire wire(String beanName) {
        this.petiteContainer.lookupExistingBeanDefinition(beanName);
        return new BeanWire(beanName);
    }

    public BeanInit init(String beanName) {
        this.petiteContainer.lookupExistingBeanDefinition(beanName);
        return new BeanInit(beanName);
    }

    public BeanDestroy destroy(String beanName) {
        this.petiteContainer.lookupExistingBeanDefinition(beanName);
        return new BeanDestroy(beanName);
    }

    public BeanProvider provider(String providerName) {
        return new BeanProvider(providerName);
    }

    public class BeanProvider {
        protected final String providerName;
        protected String beanName;
        protected Class type;
        protected String methodName;
        protected Class[] methodArgsTypes;

        private BeanProvider(String providerName) {
            this.providerName = providerName;
        }

        public BeanProvider bean(String beanName) {
            if (this.type != null) {
                throw new PetiteException("Petite provider type already defined");
            }
            this.beanName = beanName;
            return this;
        }

        public BeanProvider type(Class type) {
            if (this.beanName != null) {
                throw new PetiteException("Petite provider bean name already defined");
            }
            this.type = type;
            return this;
        }

        public BeanProvider method(String methodName) {
            this.methodName = methodName;
            return this;
        }

        public BeanProvider args(Class ... methodArgsTypes) {
            if (methodArgsTypes.length == 0) {
                methodArgsTypes = ReflectUtil.NO_PARAMETERS;
            }
            this.methodArgsTypes = methodArgsTypes;
            return this;
        }

        public void register() {
            if (this.type != null) {
                PetiteRegistry.this.petiteContainer.registerPetiteProvider(this.providerName, this.type, this.methodName, this.methodArgsTypes);
            } else {
                PetiteRegistry.this.petiteContainer.registerPetiteProvider(this.providerName, this.beanName, this.methodName, this.methodArgsTypes);
            }
        }
    }

    public class BeanDestroy {
        protected final String beanName;
        protected String[] methods;

        private BeanDestroy(String beanName) {
            this.beanName = beanName;
        }

        public BeanDestroy methods(String ... methods) {
            if (methods.length == 0) {
                methods = null;
            }
            this.methods = methods;
            return this;
        }

        public void register() {
            PetiteRegistry.this.petiteContainer.registerPetiteDestroyMethods(this.beanName, this.methods);
        }
    }

    public class BeanInit {
        protected final String beanName;
        protected String[] methods;
        protected InitMethodInvocationStrategy strategy;

        private BeanInit(String beanName) {
            this.beanName = beanName;
        }

        public BeanInit methods(String ... methods) {
            if (methods.length == 0) {
                methods = null;
            }
            this.methods = methods;
            return this;
        }

        public BeanInit invoke(InitMethodInvocationStrategy strategy) {
            this.strategy = strategy;
            return this;
        }

        public void register() {
            PetiteRegistry.this.petiteContainer.registerPetiteInitMethods(this.beanName, this.strategy, this.methods);
        }
    }

    public class BeanWire {
        protected final String beanName;

        private BeanWire(String beanName) {
            this.beanName = beanName;
        }

        public BeanWireProperty property(String propertyName) {
            return new BeanWireProperty(propertyName);
        }

        public BeanWireCtor ctor(Class ... ctorArgumentTypes) {
            return new BeanWireCtor(ctorArgumentTypes);
        }

        public BeanWireMethod method(String methodName) {
            return new BeanWireMethod(methodName);
        }

        public BeanWireSet set(String setPropertyName) {
            return new BeanWireSet(setPropertyName);
        }

        public class BeanWireSet {
            protected final String setPropertyName;
            protected String reference;

            private BeanWireSet(String setPropertyName) {
                this.setPropertyName = setPropertyName;
            }

            public BeanWireSet ref(String reference) {
                this.reference = reference;
                return this;
            }

            public void bind() {
                PetiteRegistry.this.petiteContainer.registerPetiteSetInjectionPoint(BeanWire.this.beanName, this.setPropertyName);
            }
        }

        public class BeanWireMethod {
            protected final String methodName;
            protected Class[] methodArgumentTypes;
            protected String[] references;

            private BeanWireMethod(String methodName) {
                this.methodName = methodName;
            }

            public BeanWireMethod args(Class ... methodArgumentTypes) {
                if (methodArgumentTypes.length == 0) {
                    methodArgumentTypes = null;
                }
                this.methodArgumentTypes = methodArgumentTypes;
                return this;
            }

            public BeanWireMethod ref(String ... references) {
                if (references.length == 0) {
                    references = null;
                }
                this.references = references;
                return this;
            }

            public void bind() {
                PetiteRegistry.this.petiteContainer.registerPetiteMethodInjectionPoint(BeanWire.this.beanName, this.methodName, this.methodArgumentTypes, this.references);
            }
        }

        public class BeanWireCtor {
            protected final Class[] ctorArgumentTypes;
            protected String[] references;

            private BeanWireCtor(Class ... ctorArgumentTypes) {
                if (ctorArgumentTypes.length == 0) {
                    ctorArgumentTypes = null;
                }
                this.ctorArgumentTypes = ctorArgumentTypes;
            }

            public BeanWireCtor ref(String ... references) {
                if (references.length == 0) {
                    references = null;
                }
                this.references = references;
                return this;
            }

            public void bind() {
                PetiteRegistry.this.petiteContainer.registerPetiteCtorInjectionPoint(BeanWire.this.beanName, this.ctorArgumentTypes, this.references);
            }
        }

        public class BeanWireProperty {
            protected final String propertyName;
            protected String reference;

            private BeanWireProperty(String propertyName) {
                this.propertyName = propertyName;
            }

            public BeanWireProperty ref(String reference) {
                this.reference = reference;
                return this;
            }

            public void bind() {
                PetiteRegistry.this.petiteContainer.registerPetitePropertyInjectionPoint(BeanWire.this.beanName, this.propertyName, this.reference);
            }
        }
    }

    public class BeanRegister {
        protected final Class beanType;
        protected String beanName;
        protected Class<? extends Scope> scopeType;
        protected WiringMode wiringMode;
        protected boolean define;

        private BeanRegister(Class beanType) {
            this.beanType = beanType;
        }

        public BeanRegister name(String name) {
            this.beanName = name;
            return this;
        }

        public BeanRegister scope(Class<? extends Scope> scope) {
            this.scopeType = scope;
            return this;
        }

        public BeanRegister wire(WiringMode wiringMode) {
            this.wiringMode = wiringMode;
            return this;
        }

        public BeanRegister define() {
            this.define = true;
            return this;
        }

        public void register() {
            PetiteRegistry.this.petiteContainer.registerPetiteBean(this.beanType, this.beanName, this.scopeType, this.wiringMode, this.define);
        }
    }
}

