/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite;

import java.util.Collection;
import java.util.HashSet;
import jodd.introspector.FieldDescriptor;
import jodd.introspector.MethodDescriptor;
import jodd.introspector.PropertyDescriptor;
import jodd.petite.PetiteException;
import jodd.util.ReflectUtil;

public class SetInjectionPoint<T> {
    public static final SetInjectionPoint[] EMPTY = new SetInjectionPoint[0];
    public final PropertyDescriptor propertyDescriptor;
    public final Class<T> type;
    public final Class targetClass;

    public SetInjectionPoint(PropertyDescriptor propertyDescriptor) {
        this.propertyDescriptor = propertyDescriptor;
        this.type = this.resolveSetType(propertyDescriptor);
        Class targetClass = null;
        MethodDescriptor writeMethodDescriptor = propertyDescriptor.getWriteMethodDescriptor();
        FieldDescriptor fieldDescriptor = propertyDescriptor.getFieldDescriptor();
        if (writeMethodDescriptor != null) {
            targetClass = writeMethodDescriptor.getSetterRawComponentType();
        }
        if (targetClass == null && fieldDescriptor != null) {
            targetClass = fieldDescriptor.getRawComponentType();
        }
        this.targetClass = targetClass;
        if (targetClass == null) {
            throw new PetiteException("Unknown Petite set component type " + this.type.getSimpleName() + '.' + propertyDescriptor.getName());
        }
    }

    protected Class<T> resolveSetType(PropertyDescriptor propertyDescriptor) {
        Class type = propertyDescriptor.getType();
        if (ReflectUtil.isTypeOf((Class)type, Collection.class)) {
            return type;
        }
        throw new PetiteException("Unsupported Petite set type: " + type.getName());
    }

    public Collection<T> createSet(int length) {
        return new HashSet(length);
    }
}

