/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite.scope;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import jodd.petite.BeanData;
import jodd.petite.BeanDefinition;
import jodd.petite.PetiteException;
import jodd.petite.scope.ProtoScope;
import jodd.petite.scope.Scope;
import jodd.petite.scope.ShutdownAwareScope;
import jodd.petite.scope.SingletonScope;
import jodd.servlet.RequestContextListener;

public class SessionScope
extends ShutdownAwareScope {
    protected static final String SESSION_BEANS_NAME = SessionScope.class.getName() + ".SESSION_BEANS.";

    protected Map<String, BeanData> registerSessionBeans(HttpSession httpSession) {
        SessionBeans sessionBeans = new SessionBeans();
        httpSession.setAttribute(SESSION_BEANS_NAME, (Object)sessionBeans);
        return sessionBeans.getBeanMap();
    }

    protected Map<String, BeanData> getSessionMap(HttpSession session) {
        SessionBeans sessionBeans = (SessionBeans)session.getAttribute(SESSION_BEANS_NAME);
        if (sessionBeans == null) {
            return null;
        }
        return sessionBeans.getBeanMap();
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }

    @Override
    public Object lookup(String name) {
        HttpSession session = this.getCurrentHttpSession();
        Map<String, BeanData> map = this.getSessionMap(session);
        if (map == null) {
            return null;
        }
        BeanData beanData = map.get(name);
        if (beanData == null) {
            return null;
        }
        return beanData.getBean();
    }

    @Override
    public void register(BeanDefinition beanDefinition, Object bean) {
        HttpSession session = this.getCurrentHttpSession();
        Map<String, BeanData> map = this.getSessionMap(session);
        if (map == null) {
            map = this.registerSessionBeans(session);
        }
        BeanData beanData = new BeanData(beanDefinition, bean);
        map.put(beanDefinition.getName(), beanData);
        this.registerDestroyableBeans(beanData);
    }

    @Override
    public void remove(String name) {
        if (this.totalRegisteredDestroyableBeans() == 0) {
            return;
        }
        HttpSession session = this.getCurrentHttpSession();
        Map<String, BeanData> map = this.getSessionMap(session);
        if (map != null) {
            map.remove(name);
        }
    }

    @Override
    public boolean accept(Scope referenceScope) {
        Class<?> refScopeType = referenceScope.getClass();
        if (refScopeType == ProtoScope.class) {
            return true;
        }
        if (refScopeType == SingletonScope.class) {
            return true;
        }
        return refScopeType == SessionScope.class;
    }

    protected HttpSession getCurrentHttpSession() {
        HttpServletRequest request = RequestContextListener.getRequest();
        if (request == null) {
            throw new PetiteException("No HTTP request bound to the current thread. Is RequestContextListener registered?");
        }
        return request.getSession();
    }

    public class SessionBeans
    implements HttpSessionBindingListener,
    Serializable {
        protected Map<String, BeanData> beanMap = new HashMap<String, BeanData>();

        public Map<String, BeanData> getBeanMap() {
            return this.beanMap;
        }

        public void valueBound(HttpSessionBindingEvent event) {
        }

        public void valueUnbound(HttpSessionBindingEvent event) {
            for (BeanData beanData : this.beanMap.values()) {
                SessionScope.this.destroyBean(beanData);
            }
        }
    }
}

