/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite.resolver;

import java.lang.reflect.Method;
import java.util.ArrayList;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.MethodDescriptor;
import jodd.petite.DestroyMethodPoint;
import jodd.petite.PetiteException;
import jodd.petite.meta.PetiteDestroyMethod;

public class DestroyMethodResolver {
    public DestroyMethodPoint[] resolve(Object bean) {
        MethodDescriptor[] allMethods;
        Class<?> type = bean.getClass();
        ArrayList<DestroyMethodPoint> list = new ArrayList<DestroyMethodPoint>();
        ClassDescriptor cd = new ClassDescriptor(type, false, false, false, null);
        for (MethodDescriptor methodDescriptor : allMethods = cd.getAllMethodDescriptors()) {
            Method method = methodDescriptor.getMethod();
            PetiteDestroyMethod petiteDestroyMethod = method.getAnnotation(PetiteDestroyMethod.class);
            if (petiteDestroyMethod == null) continue;
            if (method.getParameterTypes().length > 0) {
                throw new PetiteException("Arguments are not allowed for Petite destroy method: " + type.getName() + '#' + method.getName());
            }
            list.add(new DestroyMethodPoint(method));
        }
        DestroyMethodPoint[] methods = list.isEmpty() ? DestroyMethodPoint.EMPTY : list.toArray(new DestroyMethodPoint[list.size()]);
        return methods;
    }
}

