/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite;

import java.util.function.Consumer;
import jodd.petite.PetiteException;
import jodd.petite.WiringMode;
import jodd.petite.def.CtorInjectionPoint;
import jodd.petite.def.DestroyMethodPoint;
import jodd.petite.def.InitMethodPoint;
import jodd.petite.def.MethodInjectionPoint;
import jodd.petite.def.PropertyInjectionPoint;
import jodd.petite.def.SetInjectionPoint;
import jodd.petite.scope.Scope;
import jodd.util.ArraysUtil;

public class BeanDefinition<T> {
    protected final String name;
    protected final Class<T> type;
    protected final Scope scope;
    protected final WiringMode wiringMode;
    protected final Consumer<T> consumer;
    protected CtorInjectionPoint ctor;
    protected PropertyInjectionPoint[] properties;
    protected SetInjectionPoint[] sets;
    protected MethodInjectionPoint[] methods;
    protected InitMethodPoint[] initMethods;
    protected DestroyMethodPoint[] destroyMethods;
    protected String[] params;

    public BeanDefinition(String name, Class<T> type, Scope scope, WiringMode wiringMode, Consumer<T> beanInitConsumer) {
        this.name = name;
        this.type = type;
        this.scope = scope;
        this.wiringMode = wiringMode;
        this.consumer = beanInitConsumer;
    }

    public String name() {
        return this.name;
    }

    public Class<T> type() {
        return this.type;
    }

    public Class<? extends Scope> scope() {
        if (this.scope == null) {
            return null;
        }
        return this.scope.getClass();
    }

    public WiringMode wiringMode() {
        return this.wiringMode;
    }

    public Consumer<T> consumer() {
        return this.consumer;
    }

    public CtorInjectionPoint ctorInjectionPoint() {
        return this.ctor;
    }

    public PropertyInjectionPoint[] propertyInjectionPoints() {
        return this.properties;
    }

    public SetInjectionPoint[] setterInjectionPoints() {
        return this.sets;
    }

    public MethodInjectionPoint[] methodInjectionPoints() {
        return this.methods;
    }

    public InitMethodPoint[] InitMethodPoints() {
        return this.initMethods;
    }

    public DestroyMethodPoint[] destroyMethodPoints() {
        return this.destroyMethods;
    }

    public String[] params() {
        return this.params;
    }

    protected Object scopeLookup() {
        if (this.scope == null) {
            throw new PetiteException("Scope not defined");
        }
        return this.scope.lookup(this.name);
    }

    protected void scopeRegister(Object object) {
        if (this.scope != null) {
            this.scope.register(this, object);
        }
    }

    protected void scopeRemove() {
        this.scope.remove(this.name);
    }

    protected void addPropertyInjectionPoint(PropertyInjectionPoint pip) {
        if (this.properties == null) {
            this.properties = new PropertyInjectionPoint[1];
            this.properties[0] = pip;
        } else {
            this.properties = (PropertyInjectionPoint[])ArraysUtil.append((Object[])this.properties, (Object)pip);
        }
    }

    protected void addSetInjectionPoint(SetInjectionPoint sip) {
        if (this.sets == null) {
            this.sets = new SetInjectionPoint[1];
            this.sets[0] = sip;
        } else {
            this.sets = (SetInjectionPoint[])ArraysUtil.append((Object[])this.sets, (Object)sip);
        }
    }

    protected void addMethodInjectionPoint(MethodInjectionPoint mip) {
        if (this.methods == null) {
            this.methods = new MethodInjectionPoint[1];
            this.methods[0] = mip;
        } else {
            this.methods = (MethodInjectionPoint[])ArraysUtil.append((Object[])this.methods, (Object)mip);
        }
    }

    protected void addInitMethodPoints(InitMethodPoint[] methods) {
        this.initMethods = this.initMethods == null ? methods : (InitMethodPoint[])ArraysUtil.join((Object[][])new InitMethodPoint[][]{this.initMethods, methods});
    }

    protected void addDestroyMethodPoints(DestroyMethodPoint[] methods) {
        this.destroyMethods = this.destroyMethods == null ? methods : (DestroyMethodPoint[])ArraysUtil.join((Object[][])new DestroyMethodPoint[][]{this.destroyMethods, methods});
    }

    public String toString() {
        return "BeanDefinition{name=" + this.name + ", type=" + this.type + ", scope=" + this.scope.getClass().getSimpleName() + ", wiring=" + (Object)((Object)this.wiringMode) + '}';
    }
}

