/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite;

import java.lang.reflect.Constructor;
import jodd.petite.BeanData;
import jodd.petite.PetiteContainer;
import jodd.petite.PetiteException;
import jodd.petite.def.DestroyMethodPoint;
import jodd.util.ClassUtil;

public class PetiteUtil {
    public static <T> T newInstance(Class<T> type, PetiteContainer petiteContainer) throws Exception {
        T t = null;
        try {
            Constructor<T> ctor = type.getConstructor(PetiteContainer.class);
            t = ctor.newInstance(petiteContainer);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (t == null) {
            return (T)ClassUtil.newInstance(type);
        }
        return t;
    }

    public static void callDestroyMethods(BeanData beanData) {
        DestroyMethodPoint[] dmp;
        for (DestroyMethodPoint destroyMethodPoint : dmp = beanData.definition().destroyMethodPoints()) {
            try {
                destroyMethodPoint.method.invoke(beanData.instance(), new Object[0]);
            }
            catch (Exception ex) {
                throw new PetiteException("Invalid destroy method: " + destroyMethodPoint.method, ex);
            }
        }
    }
}

