/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite;

import java.util.function.Consumer;
import jodd.io.findfile.ClassScanner;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.petite.PetiteContainer;
import jodd.petite.PetiteException;
import jodd.petite.meta.PetiteBean;

public class AutomagicPetiteConfigurator {
    private static final Logger log = LoggerFactory.getLogger(AutomagicPetiteConfigurator.class);
    private final ClassScanner classScanner = new ClassScanner();
    private PetiteContainer container;
    private final byte[] petiteBeanAnnotationBytes;
    protected long elapsed;
    private Consumer<ClassScanner.EntryData> ENTRY_CONSUMER = new Consumer<ClassScanner.EntryData>(){

        @Override
        public void accept(ClassScanner.EntryData entryData) {
            Class beanClass;
            String entryName = entryData.name();
            if (!entryData.isTypeSignatureInUse(AutomagicPetiteConfigurator.this.petiteBeanAnnotationBytes)) {
                return;
            }
            try {
                beanClass = AutomagicPetiteConfigurator.this.classScanner.loadClass(entryName);
            }
            catch (ClassNotFoundException cnfex) {
                throw new PetiteException("Unable to load class: " + cnfex, cnfex);
            }
            if (beanClass == null) {
                return;
            }
            PetiteBean petiteBean = beanClass.getAnnotation(PetiteBean.class);
            if (petiteBean == null) {
                return;
            }
            AutomagicPetiteConfigurator.this.container.registerPetiteBean(beanClass, null, null, null, false, null);
        }
    };

    public AutomagicPetiteConfigurator() {
        this.petiteBeanAnnotationBytes = ClassScanner.bytecodeSignatureOfType(PetiteBean.class);
    }

    public long elapsedTime() {
        return this.elapsed;
    }

    public AutomagicPetiteConfigurator withScanner(Consumer<ClassScanner> scannerConsumer) {
        scannerConsumer.accept(this.classScanner);
        return this;
    }

    public void configure(PetiteContainer petiteContainer) {
        this.container = petiteContainer;
        this.classScanner.smartModeEntries();
        this.classScanner.onEntry(this.ENTRY_CONSUMER);
        this.classScanner.scanDefaultClasspath();
        this.elapsed = System.currentTimeMillis();
        try {
            this.classScanner.start();
        }
        catch (Exception ex) {
            throw new PetiteException("Scan classpath error", ex);
        }
        this.elapsed = System.currentTimeMillis() - this.elapsed;
        log.info("Petite configured in " + this.elapsed + " ms. Total beans: " + petiteContainer.beansCount());
    }
}

