/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite.resolver;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import jodd.bean.JoddBean;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.MethodDescriptor;
import jodd.petite.BeanDefinition;
import jodd.petite.def.ProviderDefinition;
import jodd.petite.meta.PetiteProvider;
import jodd.util.StringUtil;

public class ProviderResolver {
    public ProviderDefinition[] resolve(BeanDefinition beanDefinition) {
        Class type = beanDefinition.type();
        ClassDescriptor cd = JoddBean.defaults().getClassIntrospector().lookup(type);
        MethodDescriptor[] methods = cd.getAllMethodDescriptors();
        ArrayList<ProviderDefinition> list = new ArrayList<ProviderDefinition>();
        for (MethodDescriptor methodDescriptor : methods) {
            Method method = methodDescriptor.getMethod();
            PetiteProvider petiteProvider = method.getAnnotation(PetiteProvider.class);
            if (petiteProvider == null) continue;
            String providerName = petiteProvider.value();
            if (StringUtil.isBlank((CharSequence)providerName) && (providerName = method.getName()).endsWith("Provider")) {
                providerName = StringUtil.substring((String)providerName, (int)0, (int)-8);
            }
            ProviderDefinition providerDefinition = Modifier.isStatic(method.getModifiers()) ? new ProviderDefinition(providerName, method) : new ProviderDefinition(providerName, beanDefinition.name(), method);
            list.add(providerDefinition);
        }
        ProviderDefinition[] providers = list.isEmpty() ? ProviderDefinition.EMPTY : list.toArray(new ProviderDefinition[list.size()]);
        return providers;
    }
}

