/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite;

import jodd.petite.BeanDefinition;
import jodd.petite.def.CtorInjectionPoint;
import jodd.petite.def.DestroyMethodPoint;
import jodd.petite.def.InitMethodPoint;
import jodd.petite.def.MethodInjectionPoint;
import jodd.petite.def.PropertyInjectionPoint;
import jodd.petite.def.ProviderDefinition;
import jodd.petite.def.SetInjectionPoint;
import jodd.petite.resolver.CtorResolver;
import jodd.petite.resolver.DestroyMethodResolver;
import jodd.petite.resolver.InitMethodResolver;
import jodd.petite.resolver.MethodResolver;
import jodd.petite.resolver.PropertyResolver;
import jodd.petite.resolver.ProviderResolver;
import jodd.petite.resolver.ReferencesResolver;
import jodd.petite.resolver.SetResolver;

public class PetiteResolvers {
    protected final ReferencesResolver referencesResolver;
    protected final CtorResolver ctorResolver;
    protected final PropertyResolver propertyResolver;
    protected final MethodResolver methodResolver;
    protected final SetResolver setResolver;
    protected final InitMethodResolver initMethodResolver;
    protected final DestroyMethodResolver destroyMethodResolver;
    protected final ProviderResolver providerResolver;

    public PetiteResolvers(ReferencesResolver referencesResolver) {
        this.referencesResolver = referencesResolver;
        this.ctorResolver = new CtorResolver(referencesResolver);
        this.methodResolver = new MethodResolver(referencesResolver);
        this.propertyResolver = new PropertyResolver(referencesResolver);
        this.setResolver = new SetResolver();
        this.initMethodResolver = new InitMethodResolver();
        this.destroyMethodResolver = new DestroyMethodResolver();
        this.providerResolver = new ProviderResolver();
    }

    public CtorInjectionPoint resolveCtorInjectionPoint(Class type) {
        return this.ctorResolver.resolve(type, true);
    }

    public PropertyInjectionPoint[] resolvePropertyInjectionPoint(Class type, boolean autowire) {
        return this.propertyResolver.resolve(type, autowire);
    }

    public MethodInjectionPoint[] resolveMethodInjectionPoint(Class type) {
        return this.methodResolver.resolve(type);
    }

    public SetInjectionPoint[] resolveSetInjectionPoint(Class type, boolean autowire) {
        return this.setResolver.resolve(type, autowire);
    }

    public InitMethodPoint[] resolveInitMethodPoint(Object bean) {
        return this.initMethodResolver.resolve(bean);
    }

    public DestroyMethodPoint[] resolveDestroyMethodPoint(Object bean) {
        return this.destroyMethodResolver.resolve(bean);
    }

    public ProviderDefinition[] resolveProviderDefinitions(BeanDefinition beanDefinition) {
        return this.providerResolver.resolve(beanDefinition);
    }
}

