/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite.scope;

import java.util.HashMap;
import java.util.Map;
import jodd.petite.BeanData;
import jodd.petite.BeanDefinition;
import jodd.petite.PetiteContainer;
import jodd.petite.scope.ProtoScope;
import jodd.petite.scope.Scope;

public class SingletonScope
implements Scope {
    private final PetiteContainer pc;
    protected Map<String, BeanData> instances = new HashMap<String, BeanData>();

    public SingletonScope(PetiteContainer pc) {
        this.pc = pc;
    }

    @Override
    public Object lookup(String name) {
        BeanData beanData = this.instances.get(name);
        if (beanData == null) {
            return null;
        }
        return beanData.bean();
    }

    @Override
    public void register(BeanDefinition beanDefinition, Object bean) {
        this.instances.put(beanDefinition.name(), new BeanData<Object>(this.pc, beanDefinition, bean));
    }

    @Override
    public void remove(String name) {
        this.instances.remove(name);
    }

    @Override
    public boolean accept(Scope referenceScope) {
        Class<?> refScopeType = referenceScope.getClass();
        if (refScopeType == ProtoScope.class) {
            return true;
        }
        return refScopeType == SingletonScope.class;
    }

    @Override
    public void shutdown() {
        for (BeanData beanData : this.instances.values()) {
            beanData.callDestroyMethods();
        }
        this.instances.clear();
    }
}

