/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite.resolver;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.MethodDescriptor;
import jodd.petite.PetiteException;
import jodd.petite.def.InitMethodPoint;
import jodd.petite.meta.PetiteInitMethod;

public class InitMethodResolver {
    public InitMethodPoint[] resolve(Class<?> type) {
        InitMethodPoint[] methods;
        MethodDescriptor[] allMethods;
        ArrayList<InitMethodPoint> list = new ArrayList<InitMethodPoint>();
        ClassDescriptor cd = new ClassDescriptor(type, false, false, false, null);
        for (MethodDescriptor methodDescriptor : allMethods = cd.getAllMethodDescriptors()) {
            Method method = methodDescriptor.getMethod();
            PetiteInitMethod petiteInitMethod = method.getAnnotation(PetiteInitMethod.class);
            if (petiteInitMethod == null) continue;
            if (method.getParameterTypes().length > 0) {
                throw new PetiteException("Arguments are not allowed for Petite init method: " + type.getName() + '#' + method.getName());
            }
            int order = petiteInitMethod.order();
            list.add(new InitMethodPoint(method, order, petiteInitMethod.invoke()));
        }
        if (list.isEmpty()) {
            methods = InitMethodPoint.EMPTY;
        } else {
            Collections.sort(list);
            methods = list.toArray(new InitMethodPoint[0]);
        }
        return methods;
    }
}

