/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite;

import java.lang.reflect.Method;
import jodd.bean.BeanUtil;
import jodd.petite.BeanData;
import jodd.petite.BeanDefinition;
import jodd.petite.PetiteBeans;
import jodd.petite.PetiteConfig;
import jodd.petite.PetiteException;
import jodd.petite.PetiteRegistry;
import jodd.petite.ScopedProxyManager;
import jodd.petite.WiringMode;
import jodd.petite.def.BeanReferences;
import jodd.petite.def.MethodInjectionPoint;
import jodd.petite.def.ProviderDefinition;
import jodd.petite.meta.InitMethodInvocationStrategy;
import jodd.petite.scope.Scope;
import jodd.petite.scope.SingletonScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PetiteContainer
extends PetiteBeans {
    private static final Logger log = LoggerFactory.getLogger(PetiteContainer.class);
    public static final String PETITE_CONTAINER_REF_NAME = "petiteContainer";
    protected final ScopedProxyManager scopedProxyManager = new ScopedProxyManager();

    public PetiteContainer() {
        this(new PetiteConfig());
    }

    public PetiteContainer(PetiteConfig config) {
        super(config);
        if (log.isDebugEnabled()) {
            log.debug("Petite container created");
        }
    }

    protected Object lookupMixingScopedBean(BeanDefinition def, BeanReferences refNames) {
        BeanDefinition refBeanDefinition;
        boolean mixing = this.petiteConfig.wireScopedProxy || this.petiteConfig.detectMixedScopes;
        Object value = null;
        if (mixing && (refBeanDefinition = this.lookupBeanDefinitions(refNames)) != null) {
            value = this.scopedProxyManager.lookupValue(this, def, refBeanDefinition);
        }
        if (value == null) {
            value = this.getBean(refNames);
        }
        return value;
    }

    public <T> T getBean(Class<T> type) {
        String name = this.resolveBeanName(type);
        return this.getBean(name);
    }

    protected Object getBean(BeanReferences beanReferences) {
        int total = beanReferences.size();
        for (int i = 0; i < total; ++i) {
            Object bean;
            String name = beanReferences.name(i);
            if (name == null || (bean = this.getBean(name)) == null) continue;
            return bean;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getBean(String name) {
        BeanDefinition def = this.lookupBeanDefinition(name);
        if (def == null) {
            ProviderDefinition providerDefinition = (ProviderDefinition)this.providers.get(name);
            if (providerDefinition != null) {
                return (T)this.invokeProvider(providerDefinition);
            }
            return null;
        }
        Object bean = def.scopeLookup();
        if (bean == null) {
            BeanDefinition beanDefinition = def;
            synchronized (beanDefinition) {
                bean = def.scopeLookup();
                if (bean == null) {
                    this.initBeanDefinition(def);
                    BeanData beanData = new BeanData(this, def);
                    this.registerBeanAndWireAndInjectParamsAndInvokeInitMethods(beanData);
                    bean = beanData.bean();
                }
            }
        }
        return (T)bean;
    }

    protected void initBeanDefinition(BeanDefinition def) {
        if (def.initMethods == null) {
            def.initMethods = this.petiteResolvers.resolveInitMethodPoint(def.type);
        }
        if (def.destroyMethods == null) {
            def.destroyMethods = this.petiteResolvers.resolveDestroyMethodPoint(def.type);
        }
        if (def.properties == null) {
            def.properties = this.petiteResolvers.resolvePropertyInjectionPoint(def.type, def.wiringMode == WiringMode.AUTOWIRE);
        }
        if (def.methods == null) {
            def.methods = this.petiteResolvers.resolveMethodInjectionPoint(def.type);
        }
        if (def.ctor == null) {
            def.ctor = this.petiteResolvers.resolveCtorInjectionPoint(def.type);
        }
        if (def.values == null) {
            def.values = this.paramManager.resolveParamInjectionPoints(def.type);
        }
        if (def.sets == null) {
            def.sets = this.petiteResolvers.resolveSetInjectionPoint(def.type, def.wiringMode == WiringMode.AUTOWIRE);
        }
        if (def.params == null) {
            def.params = this.paramManager.filterParametersForBeanName(def.name, this.petiteConfig.getResolveReferenceParameters());
        }
    }

    protected void registerBeanAndWireAndInjectParamsAndInvokeInitMethods(BeanData beanData) {
        this.initBeanDefinition(beanData.definition());
        beanData.scopeRegister();
        beanData.invokeInitMethods(InitMethodInvocationStrategy.POST_CONSTRUCT);
        beanData.wireBean();
        beanData.invokeInitMethods(InitMethodInvocationStrategy.POST_DEFINE);
        beanData.injectParams(this.paramManager, this.petiteConfig.isImplicitParamInjection());
        beanData.invokeInitMethods(InitMethodInvocationStrategy.POST_INITIALIZE);
        beanData.invokeConsumerIfRegistered();
    }

    public void wire(Object bean) {
        this.wire(bean, null);
    }

    public void wire(Object bean, WiringMode wiringMode) {
        WiringMode finalWiringMode = this.petiteConfig.resolveWiringMode(wiringMode);
        BeanDefinition def = (BeanDefinition)this.externalsCache.get(bean.getClass(), c -> {
            BeanDefinition beanDefinition = this.createBeandDefinitionForExternalBeans(c, finalWiringMode);
            this.initBeanDefinition(beanDefinition);
            return beanDefinition;
        });
        this.registerBeanAndWireAndInjectParamsAndInvokeInitMethods(new BeanData<Object>(this, def, bean));
    }

    public <T> T invokeMethod(Object bean, Method method) {
        WiringMode wiringMode = this.petiteConfig.resolveWiringMode(null);
        BeanDefinition def = (BeanDefinition)this.externalsCache.get(bean.getClass(), c -> {
            BeanDefinition beanDefinition = this.createBeandDefinitionForExternalBeans(c, wiringMode);
            this.initBeanDefinition(beanDefinition);
            return beanDefinition;
        });
        BeanData<Object> beanData = new BeanData<Object>(this, def, bean);
        for (MethodInjectionPoint methodInjectionPoint : def.methods) {
            if (!methodInjectionPoint.method.equals(method)) continue;
            return (T)beanData.invokeMethodInjectionPoint(methodInjectionPoint);
        }
        try {
            return (T)method.invoke(bean, new Object[0]);
        }
        catch (Exception e) {
            throw new PetiteException(e);
        }
    }

    public <E> E createBean(Class<E> type) {
        return this.createBean(type, null);
    }

    public <E> E createBean(Class<E> type, WiringMode wiringMode) {
        WiringMode finalWiringMode = this.petiteConfig.resolveWiringMode(wiringMode);
        BeanDefinition def = (BeanDefinition)this.externalsCache.get(type, t -> {
            BeanDefinition beanDefinition = this.createBeandDefinitionForExternalBeans(t, finalWiringMode);
            this.initBeanDefinition(beanDefinition);
            return beanDefinition;
        });
        BeanData beanData = new BeanData(this, def);
        this.registerBeanAndWireAndInjectParamsAndInvokeInitMethods(beanData);
        return (E)beanData.bean();
    }

    protected Object invokeProvider(ProviderDefinition provider) {
        if (provider.method != null) {
            Object bean = provider.beanName != null ? this.getBean(provider.beanName) : null;
            try {
                return provider.method.invoke(bean, new Object[0]);
            }
            catch (Exception ex) {
                throw new PetiteException("Invalid provider method: " + provider.method.getName(), ex);
            }
        }
        throw new PetiteException("Invalid provider");
    }

    public void addBean(String name, Object bean) {
        this.addBean(name, bean, null);
    }

    public void addBean(String name, Object bean, WiringMode wiringMode) {
        wiringMode = this.petiteConfig.resolveWiringMode(wiringMode);
        this.registerPetiteBean(bean.getClass(), name, SingletonScope.class, wiringMode, false, null);
        BeanDefinition def = this.lookupExistingBeanDefinition(name);
        this.registerBeanAndWireAndInjectParamsAndInvokeInitMethods(new BeanData<Object>(this, def, bean));
    }

    public void addSelf(String name) {
        this.addBean(name, this, WiringMode.NONE);
    }

    public void addSelf() {
        this.addBean(PETITE_CONTAINER_REF_NAME, this, WiringMode.NONE);
    }

    public void setBeanProperty(String name, Object value) {
        String beanName;
        Object bean = null;
        int ndx = name.length();
        while ((ndx = name.lastIndexOf(46, ndx)) != -1 && (bean = this.getBean(beanName = name.substring(0, ndx))) == null) {
            --ndx;
        }
        if (bean == null) {
            throw new PetiteException("Invalid bean property: " + name);
        }
        try {
            BeanUtil.declared.setProperty(bean, name.substring(ndx + 1), value);
        }
        catch (Exception ex) {
            throw new PetiteException("Invalid bean property: " + name, ex);
        }
    }

    public Object getBeanProperty(String name) {
        int ndx = name.indexOf(46);
        if (ndx == -1) {
            throw new PetiteException("Only bean name is specified, missing property name: " + name);
        }
        String beanName = name.substring(0, ndx);
        Object bean = this.getBean(beanName);
        if (bean == null) {
            throw new PetiteException("Bean doesn't exist: " + name);
        }
        try {
            return BeanUtil.declared.getProperty(bean, name.substring(ndx + 1));
        }
        catch (Exception ex) {
            throw new PetiteException("Invalid bean property: " + name, ex);
        }
    }

    public PetiteRegistry createContainerRegistry() {
        return PetiteRegistry.of(this);
    }

    public void shutdown() {
        this.scopes.forEachValue(Scope::shutdown);
        this.externalsCache.clear();
        this.beans.clear();
        this.beansAlt.clear();
        this.scopes.clear();
        this.providers.clear();
        this.beanCollections.clear();
    }
}

