/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import jodd.petite.BeanDefinition;
import jodd.petite.PetiteContainer;
import jodd.petite.PetiteException;
import jodd.petite.ScopedProxyAdvice;
import jodd.petite.proxetta.ProxettaBeanDefinition;
import jodd.petite.scope.Scope;
import jodd.proxetta.Proxetta;
import jodd.proxetta.ProxyAspect;
import jodd.proxetta.ProxyPointcut;
import jodd.proxetta.impl.ProxyProxetta;
import jodd.proxetta.impl.ProxyProxettaFactory;
import jodd.proxetta.pointcuts.AllMethodsPointcut;
import jodd.util.ArraysUtil;
import jodd.util.ClassUtil;
import jodd.util.TypeCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScopedProxyManager {
    private static final Logger log = LoggerFactory.getLogger(ScopedProxyManager.class);
    protected ProxyAspect aspect = new ProxyAspect(ScopedProxyAdvice.class, (ProxyPointcut)new AllMethodsPointcut());
    protected TypeCache<Class> proxyClasses = TypeCache.createDefault();
    protected Map<String, Object> proxies = new HashMap<String, Object>();

    public ScopedProxyManager() {
        log.debug("ScopedProxyManager created");
    }

    public Object lookupValue(PetiteContainer petiteContainer, BeanDefinition targetBeanDefinition, BeanDefinition refBeanDefinition) {
        Scope targetScope = targetBeanDefinition.scope;
        Scope refBeanScope = refBeanDefinition.scope;
        boolean detectMixedScopes = petiteContainer.config().isDetectMixedScopes();
        boolean wireScopedProxy = petiteContainer.config().isWireScopedProxy();
        if (targetScope != null && !targetScope.accept(refBeanScope)) {
            String scopedProxyBeanName;
            Object proxy;
            if (!wireScopedProxy) {
                if (detectMixedScopes) {
                    throw new PetiteException(this.createMixingMessage(targetBeanDefinition, refBeanDefinition));
                }
                return null;
            }
            if (detectMixedScopes) {
                if (log.isWarnEnabled()) {
                    log.warn(this.createMixingMessage(targetBeanDefinition, refBeanDefinition));
                }
            } else if (log.isDebugEnabled()) {
                log.debug(this.createMixingMessage(targetBeanDefinition, refBeanDefinition));
            }
            if ((proxy = this.proxies.get(scopedProxyBeanName = refBeanDefinition.name)) == null) {
                proxy = this.createScopedProxyBean(petiteContainer, refBeanDefinition);
                this.proxies.put(scopedProxyBeanName, proxy);
            }
            return proxy;
        }
        return null;
    }

    protected String createMixingMessage(BeanDefinition targetBeanDefinition, BeanDefinition refBeanDefinition) {
        return "Scopes mixing detected: " + refBeanDefinition.name + "@" + refBeanDefinition.scope.getClass().getSimpleName() + " -> " + targetBeanDefinition.name + "@" + targetBeanDefinition.scope.getClass().getSimpleName();
    }

    protected Object createScopedProxyBean(PetiteContainer petiteContainer, BeanDefinition refBeanDefinition) {
        Object proxy;
        Class beanType = refBeanDefinition.type;
        Class proxyClass = (Class)this.proxyClasses.get(beanType);
        if (proxyClass == null) {
            if (refBeanDefinition instanceof ProxettaBeanDefinition) {
                ProxettaBeanDefinition pbd = (ProxettaBeanDefinition)refBeanDefinition;
                ProxyProxetta proxetta = (ProxyProxetta)Proxetta.proxyProxetta().withAspects((Object[])((ProxyAspect[])ArraysUtil.insert((Object[])pbd.proxyAspects, (Object)this.aspect, (int)0)));
                proxetta.setClassNameSuffix("$ScopedProxy");
                proxetta.setVariableClassName(true);
                ProxyProxettaFactory builder = proxetta.proxy().setTarget(pbd.originalTarget);
                proxyClass = builder.define();
                this.proxyClasses.put(beanType, (Object)proxyClass);
            } else {
                ProxyProxetta proxetta = (ProxyProxetta)Proxetta.proxyProxetta().withAspect((Object)this.aspect);
                proxetta.setClassNameSuffix("$ScopedProxy");
                proxetta.setVariableClassName(true);
                ProxyProxettaFactory builder = proxetta.proxy().setTarget(beanType);
                proxyClass = builder.define();
                this.proxyClasses.put(beanType, (Object)proxyClass);
            }
        }
        try {
            proxy = ClassUtil.newInstance((Class)proxyClass);
            Field field = proxyClass.getField("$__petiteContainer$0");
            field.set(proxy, petiteContainer);
            field = proxyClass.getField("$__name$0");
            field.set(proxy, refBeanDefinition.name);
        }
        catch (Exception ex) {
            throw new PetiteException(ex);
        }
        return proxy;
    }
}

