/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import jodd.petite.PetiteContainer;
import jodd.petite.meta.PetiteBean;
import jodd.util.StringPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutomagicPetiteConfigurator {
    private static final Logger log = LoggerFactory.getLogger(AutomagicPetiteConfigurator.class);
    private final PetiteContainer container;
    private String[] packages = StringPool.EMPTY_ARRAY;

    public AutomagicPetiteConfigurator(PetiteContainer petiteContainer) {
        this.container = petiteContainer;
    }

    public AutomagicPetiteConfigurator setPackages(String ... packages) {
        this.packages = packages;
        return this;
    }

    public void configure() {
        long elapsed = System.currentTimeMillis();
        String petiteBeanAnnotation = PetiteBean.class.getName();
        try (ScanResult scanResult = new ClassGraph().acceptPackages(this.packages).enableAnnotationInfo().enableClassInfo().scan();){
            for (ClassInfo routeClassInfo : scanResult.getClassesWithAnnotation(petiteBeanAnnotation)) {
                Class beanClass = routeClassInfo.loadClass();
                this.container.registerPetiteBean(beanClass, null, null, null, false, null);
            }
        }
        elapsed = System.currentTimeMillis() - elapsed;
        log.info("Petite configured in " + elapsed + " ms. Total beans: " + this.container.beansCount());
    }
}

