/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite;

import java.util.Collection;
import jodd.bean.BeanUtil;
import jodd.introspector.Setter;
import jodd.petite.BeanDefinition;
import jodd.petite.ParamManager;
import jodd.petite.PetiteContainer;
import jodd.petite.PetiteException;
import jodd.petite.WiringMode;
import jodd.petite.def.BeanReferences;
import jodd.petite.def.CtorInjectionPoint;
import jodd.petite.def.DestroyMethodPoint;
import jodd.petite.def.InitMethodPoint;
import jodd.petite.def.MethodInjectionPoint;
import jodd.petite.def.PropertyInjectionPoint;
import jodd.petite.def.SetInjectionPoint;
import jodd.petite.def.ValueInjectionPoint;
import jodd.petite.meta.InitMethodInvocationStrategy;

public class BeanData<T> {
    private final PetiteContainer pc;
    private final BeanDefinition<T> beanDefinition;
    private final T bean;

    public BeanData(PetiteContainer petiteContainer, BeanDefinition<T> beanDefinition, T bean) {
        this.pc = petiteContainer;
        this.beanDefinition = beanDefinition;
        this.bean = bean;
    }

    public BeanData(PetiteContainer petiteContainer, BeanDefinition<T> beanDefinition) {
        this.pc = petiteContainer;
        this.beanDefinition = beanDefinition;
        this.bean = this.newBeanInstance();
    }

    public BeanDefinition<T> definition() {
        return this.beanDefinition;
    }

    public T bean() {
        return this.bean;
    }

    public void scopeRegister() {
        this.beanDefinition.scopeRegister(this.bean);
    }

    public void invokeInitMethods(InitMethodInvocationStrategy invocationStrategy) {
        for (InitMethodPoint initMethod : this.beanDefinition.initMethodPoints()) {
            if (invocationStrategy != initMethod.invocationStrategy) continue;
            try {
                initMethod.method.invoke(this.bean, new Object[0]);
            }
            catch (Exception ex) {
                throw new PetiteException("Invalid init method: " + initMethod, ex);
            }
        }
    }

    public void callDestroyMethods() {
        for (DestroyMethodPoint destroyMethodPoint : this.beanDefinition.destroyMethodPoints()) {
            try {
                destroyMethodPoint.method.invoke(this.bean, new Object[0]);
            }
            catch (Exception ex) {
                throw new PetiteException("Invalid destroy method: " + destroyMethodPoint.method, ex);
            }
        }
    }

    public void invokeConsumerIfRegistered() {
        if (this.beanDefinition.consumer() == null) {
            return;
        }
        this.beanDefinition.consumer().accept(this.bean);
    }

    public Object newBeanInstance() {
        Object bean;
        if (this.beanDefinition.ctor == CtorInjectionPoint.EMPTY) {
            throw new PetiteException("No constructor (annotated, single or default) founded as injection point for: " + this.beanDefinition.type.getName());
        }
        int paramNo = this.beanDefinition.ctor.references.length;
        Object[] args = new Object[paramNo];
        if (this.beanDefinition.wiringMode != WiringMode.NONE) {
            for (int i = 0; i < paramNo; ++i) {
                args[i] = this.pc.getBean(this.beanDefinition.ctor.references[i]);
                if (args[i] != null || this.beanDefinition.wiringMode != WiringMode.STRICT) continue;
                throw new PetiteException("Wiring constructor failed. References '" + this.beanDefinition.ctor.references[i] + "' not found for constructor: " + this.beanDefinition.ctor.constructor);
            }
        }
        try {
            bean = this.beanDefinition.ctor.constructor.newInstance(args);
        }
        catch (Exception ex) {
            throw new PetiteException("Failed to create new bean instance '" + this.beanDefinition.type.getName() + "' using constructor: " + this.beanDefinition.ctor.constructor, ex);
        }
        return bean;
    }

    public void injectParams(ParamManager paramManager, boolean implicitParamInjection) {
        if (this.beanDefinition.name == null) {
            return;
        }
        if (implicitParamInjection) {
            int len = this.beanDefinition.name.length() + 1;
            String[] stringArray = this.beanDefinition.params;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String param = stringArray[i];
                Object value = paramManager.get(param);
                String destination = param.substring(len);
                try {
                    BeanUtil.declared.setProperty(this.bean, destination, value);
                    continue;
                }
                catch (Exception ex) {
                    throw new PetiteException("Unable to set parameter: '" + param + "' to bean: " + this.beanDefinition.name, ex);
                }
            }
        }
        for (ValueInjectionPoint pip : this.beanDefinition.values) {
            String value = paramManager.parseKeyTemplate(pip.valueTemplate);
            try {
                BeanUtil.declared.setProperty(this.bean, pip.property, (Object)value);
            }
            catch (Exception ex) {
                throw new PetiteException("Unable to set value for: '" + pip.valueTemplate + "' to bean: " + this.beanDefinition.name, ex);
            }
        }
    }

    public void wireBean() {
        if (this.definition().wiringMode == WiringMode.NONE) {
            return;
        }
        this.wireProperties();
        this.wireSets();
        this.wireMethods();
    }

    protected void wireProperties() {
        for (PropertyInjectionPoint pip : this.beanDefinition.properties) {
            BeanReferences refNames = pip.references;
            Object value = this.pc.lookupMixingScopedBean(this.definition(), refNames);
            if (value == null) {
                if (this.beanDefinition.wiringMode != WiringMode.STRICT) continue;
                throw new PetiteException("Wiring failed. Beans references: '" + refNames + "' not found for property: " + this.beanDefinition.type.getName() + '#' + pip.propertyDescriptor.getName());
            }
            Setter setter = pip.propertyDescriptor.getSetter(true);
            try {
                setter.invokeSetter(this.bean, value);
            }
            catch (Exception ex) {
                throw new PetiteException("Wiring failed", ex);
            }
        }
    }

    protected void wireSets() {
        for (SetInjectionPoint sip : this.definition().sets) {
            String[] beanNames = this.pc.resolveBeanNamesForType(sip.targetClass);
            Collection beans = sip.createSet(beanNames.length);
            for (String beanName : beanNames) {
                if (beanName.equals(this.definition().name)) continue;
                Object value = this.pc.getBean(beanName);
                beans.add(value);
            }
            Setter setter = sip.propertyDescriptor.getSetter(true);
            try {
                setter.invokeSetter(this.bean, beans);
            }
            catch (Exception ex) {
                throw new PetiteException("Wiring failed", ex);
            }
        }
    }

    protected void wireMethods() {
        for (MethodInjectionPoint methodRef : this.definition().methods) {
            this.invokeMethodInjectionPoint(methodRef);
        }
    }

    public Object invokeMethodInjectionPoint(MethodInjectionPoint methodRef) {
        BeanReferences[] refNames = methodRef.references;
        Object[] args = new Object[refNames.length];
        for (int i = 0; i < refNames.length; ++i) {
            Object value;
            BeanReferences refName = refNames[i];
            args[i] = value = this.pc.lookupMixingScopedBean(this.beanDefinition, refName);
            if (value != null || this.beanDefinition.wiringMode != WiringMode.STRICT) continue;
            throw new PetiteException("Wiring failed. Beans references: '" + refName + "' not found for method: " + this.beanDefinition.type.getName() + '#' + methodRef.method.getName());
        }
        try {
            return methodRef.method.invoke(this.bean, args);
        }
        catch (Exception ex) {
            throw new PetiteException(ex);
        }
    }
}

