/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.introspector.CtorDescriptor;
import jodd.introspector.MethodDescriptor;
import jodd.introspector.PropertyDescriptor;
import jodd.petite.AnnotationResolver;
import jodd.petite.BeanDefinition;
import jodd.petite.ParamManager;
import jodd.petite.PetiteConfig;
import jodd.petite.PetiteContainer;
import jodd.petite.PetiteException;
import jodd.petite.PetiteResolvers;
import jodd.petite.WiringMode;
import jodd.petite.def.BeanReferences;
import jodd.petite.def.CtorInjectionPoint;
import jodd.petite.def.DestroyMethodPoint;
import jodd.petite.def.InitMethodPoint;
import jodd.petite.def.MethodInjectionPoint;
import jodd.petite.def.PropertyInjectionPoint;
import jodd.petite.def.ProviderDefinition;
import jodd.petite.def.SetInjectionPoint;
import jodd.petite.meta.InitMethodInvocationStrategy;
import jodd.petite.resolver.ReferencesResolver;
import jodd.petite.scope.Scope;
import jodd.petite.scope.SingletonScope;
import jodd.props.Props;
import jodd.util.ClassUtil;
import jodd.util.StringPool;
import jodd.util.TypeCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PetiteBeans {
    private static final Logger log = LoggerFactory.getLogger(PetiteBeans.class);
    protected final Map<String, BeanDefinition> beans = new HashMap<String, BeanDefinition>();
    protected final Map<String, BeanDefinition> beansAlt = new HashMap<String, BeanDefinition>();
    protected final TypeCache<Scope> scopes = TypeCache.createDefault();
    protected final Map<String, ProviderDefinition> providers = new HashMap<String, ProviderDefinition>();
    protected final TypeCache<String[]> beanCollections = TypeCache.createDefault();
    protected TypeCache<BeanDefinition> externalsCache = TypeCache.create().noCache().get();
    protected final PetiteConfig petiteConfig;
    protected final ReferencesResolver referencesResolver;
    protected final PetiteResolvers petiteResolvers;
    protected final ParamManager paramManager;
    protected final AnnotationResolver annotationResolver;

    public void setExternalsCache(TypeCache<BeanDefinition> typeCacheImplementation) {
        this.externalsCache = typeCacheImplementation;
    }

    protected PetiteBeans(PetiteConfig petiteConfig) {
        this.petiteConfig = petiteConfig;
        this.referencesResolver = new ReferencesResolver(petiteConfig);
        this.petiteResolvers = new PetiteResolvers(this.referencesResolver);
        this.paramManager = new ParamManager();
        this.annotationResolver = new AnnotationResolver();
    }

    public ParamManager paramManager() {
        return this.paramManager;
    }

    public PetiteConfig config() {
        return this.petiteConfig;
    }

    public <S extends Scope> S resolveScope(Class<S> scopeType) {
        Scope scope = (Scope)this.scopes.get(scopeType);
        if (scope == null) {
            try {
                scope = (Scope)this.newInternalInstance(scopeType, (PetiteContainer)this);
            }
            catch (Exception ex) {
                throw new PetiteException("Invalid Petite scope: " + scopeType.getName(), ex);
            }
            this.registerScope(scopeType, scope);
            this.scopes.put(scopeType, (Object)scope);
        }
        return (S)scope;
    }

    private <T> T newInternalInstance(Class<T> type, PetiteContainer petiteContainer) throws Exception {
        T t = null;
        try {
            Constructor<T> ctor = type.getConstructor(PetiteContainer.class);
            t = ctor.newInstance(petiteContainer);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (t == null) {
            return (T)ClassUtil.newInstance(type);
        }
        return t;
    }

    public void registerScope(Class<? extends Scope> scopeType, Scope scope) {
        this.scopes.put(scopeType, (Object)scope);
    }

    public BeanDefinition lookupBeanDefinition(String name) {
        BeanDefinition beanDefinition = this.beans.get(name);
        if (beanDefinition == null && this.petiteConfig.isUseAltBeanNames()) {
            beanDefinition = this.beansAlt.get(name);
        }
        return beanDefinition;
    }

    protected BeanDefinition lookupBeanDefinitions(BeanReferences beanReferences) {
        int total = beanReferences.size();
        for (int i = 0; i < total; ++i) {
            String name = beanReferences.name(i);
            BeanDefinition beanDefinition = this.lookupBeanDefinition(name);
            if (beanDefinition == null) continue;
            return beanDefinition;
        }
        return null;
    }

    protected BeanDefinition lookupExistingBeanDefinition(String name) {
        BeanDefinition beanDefinition = this.lookupBeanDefinition(name);
        if (beanDefinition == null) {
            throw new PetiteException("Bean not found: " + name);
        }
        return beanDefinition;
    }

    public boolean isBeanNameRegistered(String name) {
        return this.lookupBeanDefinition(name) != null;
    }

    public String resolveBeanName(Class type) {
        return this.annotationResolver.resolveBeanName(type, this.petiteConfig.getUseFullTypeNames());
    }

    protected <T> BeanDefinition createBeanDefinitionForRegistration(String name, Class<T> type, Scope scope, WiringMode wiringMode, Consumer<T> consumer) {
        return new BeanDefinition<T>(name, type, scope, wiringMode, consumer);
    }

    protected <T> BeanDefinition createBeandDefinitionForExternalBeans(Class<T> type, WiringMode wiringMode) {
        String name = this.resolveBeanName(type);
        return new BeanDefinition<T>(name, type, null, wiringMode, null);
    }

    public BeanDefinition registerPetiteBean(Class type) {
        return this.registerPetiteBean(type, null, null, null, false, null);
    }

    public <T> BeanDefinition<T> registerPetiteBean(Class<T> type, Consumer<T> consumer) {
        return this.registerPetiteBean(type, null, null, null, false, consumer);
    }

    public <T> BeanDefinition<T> registerPetiteBean(Class<T> type, String name, Class<? extends Scope> scopeType, WiringMode wiringMode, boolean define, Consumer<T> consumer) {
        BeanDefinition existing;
        if (name == null) {
            name = this.resolveBeanName(type);
        }
        if (wiringMode == null) {
            wiringMode = this.annotationResolver.resolveBeanWiringMode(type);
        }
        if (wiringMode == WiringMode.DEFAULT) {
            wiringMode = this.petiteConfig.getDefaultWiringMode();
        }
        if (scopeType == null) {
            scopeType = this.annotationResolver.resolveBeanScopeType(type);
        }
        if (scopeType == null) {
            scopeType = SingletonScope.class;
        }
        if ((existing = this.removeBean(name)) != null && this.petiteConfig.getDetectDuplicatedBeanNames()) {
            throw new PetiteException("Duplicated bean name detected while registering class '" + type.getName() + "'. Petite bean class '" + existing.type.getName() + "' is already registered with the name: " + name);
        }
        if (type.isInterface()) {
            throw new PetiteException("PetiteBean can not be an interface: " + type.getName());
        }
        if (log.isDebugEnabled()) {
            log.info("Petite bean: [" + name + "] --> " + type.getName() + " @ " + scopeType.getSimpleName() + ":" + wiringMode.toString());
        }
        Scope scope = this.resolveScope(scopeType);
        BeanDefinition beanDefinition = this.createBeanDefinitionForRegistration(name, type, scope, wiringMode, consumer);
        this.registerBean(name, beanDefinition);
        ProviderDefinition[] providerDefinitions = this.petiteResolvers.resolveProviderDefinitions(type, name);
        if (providerDefinitions != null) {
            for (ProviderDefinition providerDefinition : providerDefinitions) {
                this.providers.put(providerDefinition.name, providerDefinition);
            }
        }
        if (define) {
            beanDefinition.ctor = this.petiteResolvers.resolveCtorInjectionPoint(beanDefinition.type());
            beanDefinition.properties = PropertyInjectionPoint.EMPTY;
            beanDefinition.methods = MethodInjectionPoint.EMPTY;
            beanDefinition.initMethods = InitMethodPoint.EMPTY;
            beanDefinition.destroyMethods = DestroyMethodPoint.EMPTY;
        }
        return beanDefinition;
    }

    protected void registerBean(String name, BeanDefinition beanDefinition) {
        Class[] interfaces;
        this.beans.put(name, beanDefinition);
        if (!this.petiteConfig.isUseAltBeanNames()) {
            return;
        }
        Class type = beanDefinition.type();
        if (this.annotationResolver.beanHasAnnotationName(type)) {
            return;
        }
        for (Class anInterface : interfaces = ClassUtil.resolveAllInterfaces(type)) {
            String altName = this.annotationResolver.resolveBeanName(anInterface, this.petiteConfig.getUseFullTypeNames());
            if (name.equals(altName) || this.beans.containsKey(altName)) continue;
            if (this.beansAlt.containsKey(altName)) {
                BeanDefinition existing = this.beansAlt.get(altName);
                if (existing == null) continue;
                this.beansAlt.put(altName, null);
                continue;
            }
            this.beansAlt.put(altName, beanDefinition);
        }
    }

    public void removeBean(Class type) {
        HashSet<String> beanNames = new HashSet<String>();
        for (BeanDefinition def : this.beans.values()) {
            if (!def.type.equals(type)) continue;
            beanNames.add(def.name);
        }
        for (String beanName : beanNames) {
            this.removeBean(beanName);
        }
    }

    public BeanDefinition removeBean(String name) {
        BeanDefinition bd = this.beans.remove(name);
        if (bd == null) {
            return null;
        }
        bd.scopeRemove();
        return bd;
    }

    protected String[] resolveBeanNamesForType(Class type) {
        String[] beanNames = (String[])this.beanCollections.get(type);
        if (beanNames != null) {
            return beanNames;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, BeanDefinition> entry : this.beans.entrySet()) {
            BeanDefinition beanDefinition = entry.getValue();
            if (!ClassUtil.isTypeOf(beanDefinition.type, (Class)type)) continue;
            String beanName = entry.getKey();
            list.add(beanName);
        }
        beanNames = list.isEmpty() ? StringPool.EMPTY_ARRAY : list.toArray(new String[0]);
        this.beanCollections.put(type, (Object)beanNames);
        return beanNames;
    }

    public void registerPetiteCtorInjectionPoint(String beanName, Class[] paramTypes, String[] references) {
        BeanDefinition beanDefinition = this.lookupExistingBeanDefinition(beanName);
        ClassDescriptor cd = ClassIntrospector.get().lookup(beanDefinition.type);
        Constructor constructor = null;
        if (paramTypes == null) {
            CtorDescriptor[] ctors = cd.getAllCtorDescriptors();
            if (ctors != null && ctors.length > 0) {
                if (ctors.length > 1) {
                    throw new PetiteException(ctors.length + " suitable constructor found as injection point for: " + beanDefinition.type.getName());
                }
                constructor = ctors[0].getConstructor();
            }
        } else {
            CtorDescriptor ctorDescriptor = cd.getCtorDescriptor(paramTypes, true);
            if (ctorDescriptor != null) {
                constructor = ctorDescriptor.getConstructor();
            }
        }
        if (constructor == null) {
            throw new PetiteException("Constructor not found: " + beanDefinition.type.getName());
        }
        BeanReferences[] ref = this.referencesResolver.resolveReferenceFromValues(constructor, references);
        beanDefinition.ctor = new CtorInjectionPoint(constructor, ref);
    }

    public void registerPetitePropertyInjectionPoint(String beanName, String property, String reference) {
        BeanDefinition beanDefinition = this.lookupExistingBeanDefinition(beanName);
        ClassDescriptor cd = ClassIntrospector.get().lookup(beanDefinition.type);
        PropertyDescriptor propertyDescriptor = cd.getPropertyDescriptor(property, true);
        if (propertyDescriptor == null) {
            throw new PetiteException("Property not found: " + beanDefinition.type.getName() + '#' + property);
        }
        BeanReferences ref = this.referencesResolver.resolveReferenceFromValue(propertyDescriptor, reference);
        PropertyInjectionPoint pip = new PropertyInjectionPoint(propertyDescriptor, ref);
        beanDefinition.addPropertyInjectionPoint(pip);
    }

    public void registerPetiteSetInjectionPoint(String beanName, String property) {
        BeanDefinition beanDefinition = this.lookupExistingBeanDefinition(beanName);
        ClassDescriptor cd = ClassIntrospector.get().lookup(beanDefinition.type);
        PropertyDescriptor propertyDescriptor = cd.getPropertyDescriptor(property, true);
        if (propertyDescriptor == null) {
            throw new PetiteException("Property not found: " + beanDefinition.type.getName() + '#' + property);
        }
        SetInjectionPoint sip = new SetInjectionPoint(propertyDescriptor);
        beanDefinition.addSetInjectionPoint(sip);
    }

    public void registerPetiteMethodInjectionPoint(String beanName, String methodName, Class[] arguments, String[] references) {
        BeanDefinition beanDefinition = this.lookupExistingBeanDefinition(beanName);
        ClassDescriptor cd = ClassIntrospector.get().lookup(beanDefinition.type);
        Method method = null;
        if (arguments == null) {
            MethodDescriptor[] methods = cd.getAllMethodDescriptors(methodName);
            if (methods != null && methods.length > 0) {
                if (methods.length > 1) {
                    throw new PetiteException(methods.length + " suitable methods found as injection points for: " + beanDefinition.type.getName() + '#' + methodName);
                }
                method = methods[0].getMethod();
            }
        } else {
            MethodDescriptor md = cd.getMethodDescriptor(methodName, arguments, true);
            if (md != null) {
                method = md.getMethod();
            }
        }
        if (method == null) {
            throw new PetiteException("Method not found: " + beanDefinition.type.getName() + '#' + methodName);
        }
        BeanReferences[] ref = this.referencesResolver.resolveReferenceFromValues(method, references);
        MethodInjectionPoint mip = new MethodInjectionPoint(method, ref);
        beanDefinition.addMethodInjectionPoint(mip);
    }

    public void registerPetiteInitMethods(String beanName, InitMethodInvocationStrategy invocationStrategy, String ... initMethodNames) {
        BeanDefinition beanDefinition = this.lookupExistingBeanDefinition(beanName);
        ClassDescriptor cd = ClassIntrospector.get().lookup(beanDefinition.type);
        if (initMethodNames == null) {
            initMethodNames = StringPool.EMPTY_ARRAY;
        }
        int total = initMethodNames.length;
        InitMethodPoint[] initMethodPoints = new InitMethodPoint[total];
        for (int i = 0; i < initMethodNames.length; ++i) {
            MethodDescriptor md = cd.getMethodDescriptor(initMethodNames[i], ClassUtil.EMPTY_CLASS_ARRAY, true);
            if (md == null) {
                throw new PetiteException("Init method not found: " + beanDefinition.type.getName() + '#' + initMethodNames[i]);
            }
            initMethodPoints[i] = new InitMethodPoint(md.getMethod(), i, invocationStrategy);
        }
        beanDefinition.addInitMethodPoints(initMethodPoints);
    }

    public void registerPetiteDestroyMethods(String beanName, String ... destroyMethodNames) {
        BeanDefinition beanDefinition = this.lookupExistingBeanDefinition(beanName);
        ClassDescriptor cd = ClassIntrospector.get().lookup(beanDefinition.type);
        if (destroyMethodNames == null) {
            destroyMethodNames = StringPool.EMPTY_ARRAY;
        }
        int total = destroyMethodNames.length;
        DestroyMethodPoint[] destroyMethodPoints = new DestroyMethodPoint[total];
        for (int i = 0; i < destroyMethodNames.length; ++i) {
            MethodDescriptor md = cd.getMethodDescriptor(destroyMethodNames[i], ClassUtil.EMPTY_CLASS_ARRAY, true);
            if (md == null) {
                throw new PetiteException("Destroy method not found: " + beanDefinition.type.getName() + '#' + destroyMethodNames[i]);
            }
            destroyMethodPoints[i] = new DestroyMethodPoint(md.getMethod());
        }
        beanDefinition.addDestroyMethodPoints(destroyMethodPoints);
    }

    public void registerPetiteProvider(String providerName, String beanName, String methodName, Class[] arguments) {
        BeanDefinition beanDefinition = this.lookupBeanDefinition(beanName);
        if (beanDefinition == null) {
            throw new PetiteException("Bean not found: " + beanName);
        }
        Class beanType = beanDefinition.type;
        ClassDescriptor cd = ClassIntrospector.get().lookup(beanType);
        MethodDescriptor md = cd.getMethodDescriptor(methodName, arguments, true);
        if (md == null) {
            throw new PetiteException("Provider method not found: " + methodName);
        }
        ProviderDefinition providerDefinition = new ProviderDefinition(providerName, beanName, md.getMethod());
        this.providers.put(providerName, providerDefinition);
    }

    public void registerPetiteProvider(String providerName, Class type, String staticMethodName, Class[] arguments) {
        ClassDescriptor cd = ClassIntrospector.get().lookup(type);
        MethodDescriptor md = cd.getMethodDescriptor(staticMethodName, arguments, true);
        if (md == null) {
            throw new PetiteException("Provider method not found: " + staticMethodName);
        }
        ProviderDefinition providerDefinition = new ProviderDefinition(providerName, md.getMethod());
        this.providers.put(providerName, providerDefinition);
    }

    public int beansCount() {
        return this.beans.size();
    }

    public int scopesCount() {
        return this.scopes.size();
    }

    public Set<String> beanNames() {
        return new HashSet<String>(this.beans.keySet());
    }

    public void forEachBean(Consumer<BeanDefinition> beanDefinitionConsumer) {
        Set<String> names = this.beanNames();
        for (String beanName : names) {
            BeanDefinition beanDefinition = this.lookupBeanDefinition(beanName);
            if (beanDefinition == null) continue;
            beanDefinitionConsumer.accept(beanDefinition);
        }
    }

    public void forEachBeanType(Class type, Consumer<String> beanNameConsumer) {
        this.forEachBean(bd -> {
            if (ClassUtil.isTypeOf(bd.type, (Class)type)) {
                beanNameConsumer.accept(bd.name);
            }
        });
    }

    public void defineParameter(String name, Object value) {
        this.paramManager.put(name, value);
    }

    public Object getParameter(String name) {
        return this.paramManager.get(name);
    }

    public void defineParameters(Map<?, ?> properties) {
        for (Map.Entry<?, ?> entry : properties.entrySet()) {
            this.defineParameter(entry.getKey().toString(), entry.getValue());
        }
    }

    public void defineParameters(Props props) {
        HashMap map = new HashMap();
        props.extractProps(map);
        this.defineParameters(map);
    }
}

