/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite.resolver;

import java.lang.reflect.Method;
import java.util.ArrayList;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.introspector.MethodDescriptor;
import jodd.petite.def.BeanReferences;
import jodd.petite.def.MethodInjectionPoint;
import jodd.petite.resolver.ReferencesResolver;
import jodd.util.ClassUtil;

public class MethodResolver {
    protected final ReferencesResolver referencesResolver;

    public MethodResolver(ReferencesResolver referencesResolver) {
        this.referencesResolver = referencesResolver;
    }

    public MethodInjectionPoint[] resolve(Class type) {
        MethodDescriptor[] allMethods;
        ClassDescriptor cd = ClassIntrospector.get().lookup(type);
        ArrayList<MethodInjectionPoint> list = new ArrayList<MethodInjectionPoint>();
        for (MethodDescriptor methodDescriptor : allMethods = cd.getAllMethodDescriptors()) {
            BeanReferences[] references;
            Method method = methodDescriptor.getMethod();
            if (method.isSynthetic() || ClassUtil.isBeanPropertySetter((Method)method) || method.getParameterTypes().length == 0 || (references = this.referencesResolver.readAllReferencesFromAnnotation(method)) == null) continue;
            MethodInjectionPoint methodInjectionPoint = new MethodInjectionPoint(method, references);
            list.add(methodInjectionPoint);
        }
        MethodInjectionPoint[] methodInjectionPoints = list.isEmpty() ? MethodInjectionPoint.EMPTY : list.toArray(new MethodInjectionPoint[0]);
        return methodInjectionPoints;
    }
}

