/*
 * Decompiled with CFR 0.152.
 */
package jodd.props;

import java.util.ArrayList;
import jodd.props.PropsData;
import jodd.util.CharUtil;
import jodd.util.StringUtil;

public class PropsParser
implements Cloneable {
    protected static final String PROFILE_LEFT = "<";
    protected static final String PROFILE_RIGHT = ">";
    protected final PropsData propsData;
    protected String escapeNewLineValue = "";
    protected boolean valueTrimLeft = true;
    protected boolean valueTrimRight = true;
    protected boolean ignorePrefixWhitespacesOnNewLine = true;
    protected boolean multilineValues = true;
    protected boolean skipEmptyProps = true;

    public PropsParser() {
        this.propsData = new PropsData();
    }

    public PropsParser(PropsData propsData) {
        this.propsData = propsData;
    }

    public PropsData getPropsData() {
        return this.propsData;
    }

    public PropsParser clone() {
        PropsParser pp = new PropsParser(this.propsData.clone());
        pp.escapeNewLineValue = this.escapeNewLineValue;
        pp.valueTrimLeft = this.valueTrimLeft;
        pp.valueTrimRight = this.valueTrimRight;
        pp.ignorePrefixWhitespacesOnNewLine = this.ignorePrefixWhitespacesOnNewLine;
        pp.skipEmptyProps = this.skipEmptyProps;
        pp.multilineValues = this.multilineValues;
        return pp;
    }

    public void parse(String in) {
        ParseState state = ParseState.TEXT;
        ParseState stateOnEscape = null;
        boolean insideSection = false;
        String currentSection = null;
        String key = null;
        boolean quickAppend = false;
        StringBuilder sb = new StringBuilder();
        int len = in.length();
        int ndx = 0;
        block23: while (ndx < len) {
            char c = in.charAt(ndx);
            ++ndx;
            if (state == ParseState.COMMENT) {
                if (c != '\n') continue;
                state = ParseState.TEXT;
                continue;
            }
            if (state == ParseState.ESCAPE) {
                state = stateOnEscape;
                switch (c) {
                    case '\n': 
                    case '\r': {
                        state = ParseState.ESCAPE_NEWLINE;
                        break;
                    }
                    case 'u': {
                        int value = 0;
                        for (int i = 0; i < 4; ++i) {
                            char hexChar;
                            if (CharUtil.isDigit((char)(hexChar = in.charAt(ndx++)))) {
                                value = (value << 4) + hexChar - 48;
                                continue;
                            }
                            if (hexChar >= 'a' && hexChar <= 'f') {
                                value = (value << 4) + 10 + hexChar - 97;
                                continue;
                            }
                            if (hexChar >= 'A' && hexChar <= 'F') {
                                value = (value << 4) + 10 + hexChar - 65;
                                continue;
                            }
                            throw new IllegalArgumentException("Malformed \\uXXXX encoding.");
                        }
                        sb.append((char)value);
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 'f': {
                        sb.append('\f');
                        break;
                    }
                    default: {
                        sb.append(c);
                        break;
                    }
                }
                continue;
            }
            if (state == ParseState.TEXT) {
                switch (c) {
                    case '\\': {
                        stateOnEscape = state;
                        state = ParseState.ESCAPE;
                        continue block23;
                    }
                    case '[': {
                        sb.setLength(0);
                        insideSection = true;
                        continue block23;
                    }
                    case ']': {
                        if (insideSection) {
                            currentSection = sb.toString().trim();
                            sb.setLength(0);
                            insideSection = false;
                            if (currentSection.length() != 0) continue block23;
                            currentSection = null;
                            continue block23;
                        }
                        sb.append(c);
                        continue block23;
                    }
                    case '#': 
                    case ';': {
                        state = ParseState.COMMENT;
                        continue block23;
                    }
                    case '+': {
                        if (ndx == len || in.charAt(ndx) != '=') {
                            sb.append(c);
                            continue block23;
                        }
                        quickAppend = true;
                        ++ndx;
                    }
                    case ':': 
                    case '=': {
                        if (key == null) {
                            key = sb.toString().trim();
                            sb.setLength(0);
                        } else {
                            sb.append(c);
                        }
                        state = ParseState.VALUE;
                        continue block23;
                    }
                    case '\n': 
                    case '\r': {
                        this.add(currentSection, key, sb, true, quickAppend);
                        sb.setLength(0);
                        key = null;
                        quickAppend = false;
                        continue block23;
                    }
                    case '\t': 
                    case ' ': {
                        continue block23;
                    }
                }
                sb.append(c);
                continue;
            }
            switch (c) {
                case '\\': {
                    stateOnEscape = state;
                    state = ParseState.ESCAPE;
                    break;
                }
                case '\n': 
                case '\r': {
                    if (state == ParseState.ESCAPE_NEWLINE && c == '\n') {
                        sb.append(this.escapeNewLineValue);
                        if (this.ignorePrefixWhitespacesOnNewLine) continue block23;
                        state = ParseState.VALUE;
                        break;
                    }
                    this.add(currentSection, key, sb, true, quickAppend);
                    sb.setLength(0);
                    key = null;
                    quickAppend = false;
                    state = ParseState.TEXT;
                    break;
                }
                case '\t': 
                case ' ': {
                    if (state == ParseState.ESCAPE_NEWLINE) break;
                }
                default: {
                    sb.append(c);
                    state = ParseState.VALUE;
                    if (!this.multilineValues || sb.length() != 3 || !sb.toString().equals("'''")) continue block23;
                    sb.setLength(0);
                    int endIndex = in.indexOf("'''", ndx);
                    if (endIndex == -1) {
                        endIndex = in.length();
                    }
                    sb.append(in, ndx, endIndex);
                    this.add(currentSection, key, sb, false, quickAppend);
                    sb.setLength(0);
                    key = null;
                    quickAppend = false;
                    state = ParseState.TEXT;
                    ndx = endIndex + 3;
                }
            }
        }
        if (key != null) {
            this.add(currentSection, key, sb, true, quickAppend);
        }
    }

    protected void add(String section, String key, StringBuilder value, boolean trim, boolean append) {
        if (key == null) {
            return;
        }
        String fullKey = key;
        if (section != null) {
            fullKey = section + '.' + fullKey;
        }
        String v = value.toString();
        if (trim) {
            v = this.valueTrimLeft && this.valueTrimRight ? v.trim() : (this.valueTrimLeft ? StringUtil.trimLeft((String)v) : StringUtil.trimRight((String)v));
        }
        if (v.length() == 0 && this.skipEmptyProps) {
            return;
        }
        this.add(fullKey, v, append);
    }

    protected void add(String key, String value, boolean append) {
        String fullKey = key;
        int ndx = fullKey.indexOf(PROFILE_LEFT);
        if (ndx == -1) {
            this.propsData.putBaseProperty(fullKey, value, append);
            return;
        }
        ArrayList<String> keyProfiles = new ArrayList<String>();
        while ((ndx = fullKey.indexOf(PROFILE_LEFT)) != -1) {
            int len = fullKey.length();
            int ndx2 = fullKey.indexOf(PROFILE_RIGHT, ndx + 1);
            if (ndx2 == -1) {
                ndx2 = len;
            }
            String profile = fullKey.substring(ndx + 1, ndx2);
            keyProfiles.add(profile);
            String right = ++ndx2 == len ? "" : fullKey.substring(ndx2);
            fullKey = fullKey.substring(0, ndx) + right;
        }
        for (String p : keyProfiles) {
            this.propsData.putProfileProperty(fullKey, value, p, append);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ParseState {
        TEXT,
        ESCAPE,
        ESCAPE_NEWLINE,
        COMMENT,
        VALUE;

    }
}

