/*
 * Decompiled with CFR 0.152.
 */
package jodd.props;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import jodd.props.PropsValue;
import jodd.util.StringTemplateParser;
import jodd.util.Wildcard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropsData
implements Cloneable {
    private static final int MAX_INNER_MACROS = 100;
    private static final String APPEND_SEPARATOR = ",";
    protected final HashMap<String, PropsValue> baseProperties;
    protected final HashMap<String, Map<String, PropsValue>> profileProperties;
    protected final StringTemplateParser stringTemplateParser;
    protected boolean appendDuplicateProps;

    public PropsData() {
        this(new HashMap<String, PropsValue>(), new HashMap<String, Map<String, PropsValue>>());
    }

    protected PropsData(HashMap<String, PropsValue> properties, HashMap<String, Map<String, PropsValue>> profiles) {
        this.baseProperties = properties;
        this.profileProperties = profiles;
        this.stringTemplateParser = new StringTemplateParser();
        this.stringTemplateParser.setResolveEscapes(false);
        this.stringTemplateParser.setReplaceMissingKey(false);
    }

    public PropsData clone() {
        HashMap<String, PropsValue> newBase = new HashMap<String, PropsValue>();
        HashMap<String, Map<String, PropsValue>> newProfiles = new HashMap<String, Map<String, PropsValue>>();
        newBase.putAll(this.baseProperties);
        for (Map.Entry<String, Map<String, PropsValue>> entry : this.profileProperties.entrySet()) {
            HashMap<String, PropsValue> map = new HashMap<String, PropsValue>(entry.getValue().size());
            map.putAll(entry.getValue());
            newProfiles.put(entry.getKey(), map);
        }
        PropsData pd = new PropsData(newBase, newProfiles);
        pd.appendDuplicateProps = this.appendDuplicateProps;
        return pd;
    }

    protected void put(Map<String, PropsValue> map, String key, String value) {
        PropsValue pv;
        String realValue = value;
        if (this.appendDuplicateProps && (pv = map.get(key)) != null) {
            realValue = pv.value + APPEND_SEPARATOR + realValue;
        }
        map.put(key, new PropsValue(realValue));
    }

    public int countBaseProperties() {
        return this.baseProperties.size();
    }

    public void putBaseProperty(String key, String value) {
        this.put(this.baseProperties, key, value);
    }

    public PropsValue getBaseProperty(String key) {
        return this.baseProperties.get(key);
    }

    public int countProfileProperties() {
        HashSet<String> profileKeys = new HashSet<String>();
        for (Map<String, PropsValue> map : this.profileProperties.values()) {
            for (String key : map.keySet()) {
                if (this.baseProperties.containsKey(key)) continue;
                profileKeys.add(key);
            }
        }
        return profileKeys.size();
    }

    public void putProfileProperty(String key, String value, String profile) {
        Map<String, PropsValue> map = this.profileProperties.get(profile);
        if (map == null) {
            map = new HashMap<String, PropsValue>();
            this.profileProperties.put(profile, map);
        }
        this.put(map, key, value);
    }

    public PropsValue getProfileProperty(String profile, String key) {
        Map<String, PropsValue> profileMap = this.profileProperties.get(profile);
        if (profileMap == null) {
            return null;
        }
        return profileMap.get(key);
    }

    protected String lookupValue(String key, String ... profiles) {
        PropsValue value;
        if (profiles != null) {
            block0: for (String profile : profiles) {
                Map<String, PropsValue> profileMap;
                while ((profileMap = this.profileProperties.get(profile)) != null) {
                    PropsValue value2 = profileMap.get(key);
                    if (value2 != null) {
                        return value2.getValue();
                    }
                    int ndx = profile.lastIndexOf(46);
                    if (ndx == -1) continue block0;
                    profile = profile.substring(0, ndx);
                }
            }
        }
        return (value = this.getBaseProperty(key)) == null ? null : value.getValue();
    }

    public void resolveMacros() {
        int loopCount = 0;
        while (loopCount++ < 100) {
            boolean replaced = this.resolveMacros(this.baseProperties, null);
            for (Map.Entry<String, Map<String, PropsValue>> entry : this.profileProperties.entrySet()) {
                String profile = entry.getKey();
                replaced = this.resolveMacros(entry.getValue(), profile) || replaced;
            }
            if (replaced) continue;
            break;
        }
    }

    protected boolean resolveMacros(Map<String, PropsValue> map, final String profile) {
        boolean replaced = false;
        StringTemplateParser.MacroResolver macroResolver = new StringTemplateParser.MacroResolver(){

            public String resolve(String macroName) {
                return PropsData.this.lookupValue(macroName, profile);
            }
        };
        for (Map.Entry<String, PropsValue> entry : map.entrySet()) {
            PropsValue pv = entry.getValue();
            String newValue = this.stringTemplateParser.parse(pv.value, macroResolver);
            if (!newValue.equals(pv.value)) {
                pv.resolved = newValue;
                replaced = true;
                continue;
            }
            pv.resolved = null;
        }
        return replaced;
    }

    public void extract(Map target, String[] profiles, String[] wildcardPatterns) {
        if (profiles != null) {
            block0: for (String profile : profiles) {
                while (true) {
                    int ndx;
                    Map<String, PropsValue> map;
                    if ((map = this.profileProperties.get(profile)) != null) {
                        this.extractMap(target, map, wildcardPatterns);
                    }
                    if ((ndx = profile.indexOf(46)) == -1) continue block0;
                    profile = profile.substring(0, ndx);
                }
            }
        }
        this.extractMap(target, this.baseProperties, wildcardPatterns);
    }

    protected void extractMap(Map target, Map<String, PropsValue> map, String[] wildcardPatterns) {
        for (Map.Entry<String, PropsValue> entry : map.entrySet()) {
            String key = entry.getKey();
            if (wildcardPatterns != null && Wildcard.matchOne((String)key, (String[])wildcardPatterns) == -1 || target.containsKey(key)) continue;
            target.put(key, entry.getValue().getValue());
        }
    }
}

