/*
 * Decompiled with CFR 0.152.
 */
package jodd.props;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import jodd.props.PropsEntry;
import jodd.util.StringTemplateParser;
import jodd.util.Wildcard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropsData
implements Cloneable {
    private static final int MAX_INNER_MACROS = 100;
    private static final String APPEND_SEPARATOR = ",";
    protected final HashMap<String, PropsEntry> baseProperties;
    protected final HashMap<String, Map<String, PropsEntry>> profileProperties;
    protected PropsEntry first;
    protected PropsEntry last;
    protected boolean appendDuplicateProps;
    protected boolean ignoreMissingMacros;
    protected boolean skipEmptyProps = true;

    public PropsData() {
        this(new HashMap<String, PropsEntry>(), new HashMap<String, Map<String, PropsEntry>>());
    }

    protected PropsData(HashMap<String, PropsEntry> properties, HashMap<String, Map<String, PropsEntry>> profiles) {
        this.baseProperties = properties;
        this.profileProperties = profiles;
    }

    public PropsData clone() {
        HashMap<String, PropsEntry> newBase = new HashMap<String, PropsEntry>();
        HashMap<String, Map<String, PropsEntry>> newProfiles = new HashMap<String, Map<String, PropsEntry>>();
        newBase.putAll(this.baseProperties);
        for (Map.Entry<String, Map<String, PropsEntry>> entry : this.profileProperties.entrySet()) {
            HashMap<String, PropsEntry> map = new HashMap<String, PropsEntry>(entry.getValue().size());
            map.putAll(entry.getValue());
            newProfiles.put(entry.getKey(), map);
        }
        PropsData pd = new PropsData(newBase, newProfiles);
        pd.appendDuplicateProps = this.appendDuplicateProps;
        pd.ignoreMissingMacros = this.ignoreMissingMacros;
        pd.skipEmptyProps = this.skipEmptyProps;
        return pd;
    }

    protected void put(String profile, Map<String, PropsEntry> map, String key, String value, boolean append) {
        PropsEntry pv;
        String realValue = value;
        if ((append || this.appendDuplicateProps) && (pv = map.get(key)) != null) {
            realValue = pv.value + APPEND_SEPARATOR + realValue;
        }
        PropsEntry propsEntry = new PropsEntry(key, realValue, profile);
        if (this.first == null) {
            this.first = propsEntry;
        } else {
            this.last.next = propsEntry;
        }
        this.last = propsEntry;
        map.put(key, propsEntry);
    }

    public int countBaseProperties() {
        return this.baseProperties.size();
    }

    public void putBaseProperty(String key, String value, boolean append) {
        this.put(null, this.baseProperties, key, value, append);
    }

    public PropsEntry getBaseProperty(String key) {
        return this.baseProperties.get(key);
    }

    public int countProfileProperties() {
        HashSet<String> profileKeys = new HashSet<String>();
        for (Map<String, PropsEntry> map : this.profileProperties.values()) {
            for (String key : map.keySet()) {
                if (this.baseProperties.containsKey(key)) continue;
                profileKeys.add(key);
            }
        }
        return profileKeys.size();
    }

    public void putProfileProperty(String key, String value, String profile, boolean append) {
        Map<String, PropsEntry> map = this.profileProperties.get(profile);
        if (map == null) {
            map = new HashMap<String, PropsEntry>();
            this.profileProperties.put(profile, map);
        }
        this.put(profile, map, key, value, append);
    }

    public PropsEntry getProfileProperty(String profile, String key) {
        Map<String, PropsEntry> profileMap = this.profileProperties.get(profile);
        if (profileMap == null) {
            return null;
        }
        return profileMap.get(key);
    }

    protected String lookupValue(String key, String ... profiles) {
        PropsEntry value;
        if (profiles != null) {
            block0: for (String profile : profiles) {
                Map<String, PropsEntry> profileMap;
                while ((profileMap = this.profileProperties.get(profile)) != null) {
                    PropsEntry value2 = profileMap.get(key);
                    if (value2 != null) {
                        return value2.getValue();
                    }
                    int ndx = profile.lastIndexOf(46);
                    if (ndx == -1) continue block0;
                    profile = profile.substring(0, ndx);
                }
            }
        }
        return (value = this.getBaseProperty(key)) == null ? null : value.getValue();
    }

    public void resolveMacros() {
        StringTemplateParser stringTemplateParser = new StringTemplateParser();
        stringTemplateParser.setResolveEscapes(false);
        if (!this.ignoreMissingMacros) {
            stringTemplateParser.setReplaceMissingKey(false);
        } else {
            stringTemplateParser.setReplaceMissingKey(true);
            stringTemplateParser.setMissingKeyReplacement("");
        }
        int loopCount = 0;
        while (loopCount++ < 100) {
            boolean replaced = this.resolveMacros(this.baseProperties, null, stringTemplateParser);
            for (Map.Entry<String, Map<String, PropsEntry>> entry : this.profileProperties.entrySet()) {
                String profile = entry.getKey();
                replaced = this.resolveMacros(entry.getValue(), profile, stringTemplateParser) || replaced;
            }
            if (replaced) continue;
            break;
        }
    }

    protected boolean resolveMacros(Map<String, PropsEntry> map, final String profile, StringTemplateParser stringTemplateParser) {
        boolean replaced = false;
        StringTemplateParser.MacroResolver macroResolver = new StringTemplateParser.MacroResolver(){

            public String resolve(String macroName) {
                return PropsData.this.lookupValue(macroName, profile);
            }
        };
        Iterator<Map.Entry<String, PropsEntry>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, PropsEntry> entry = iterator.next();
            PropsEntry pv = entry.getValue();
            String newValue = stringTemplateParser.parse(pv.value, macroResolver);
            if (!newValue.equals(pv.value)) {
                if (this.skipEmptyProps && newValue.length() == 0) {
                    iterator.remove();
                    replaced = true;
                    continue;
                }
                pv.resolved = newValue;
                replaced = true;
                continue;
            }
            pv.resolved = null;
        }
        return replaced;
    }

    public void extract(Map target, String[] profiles, String[] wildcardPatterns) {
        if (profiles != null) {
            block0: for (String profile : profiles) {
                while (true) {
                    int ndx;
                    Map<String, PropsEntry> map;
                    if ((map = this.profileProperties.get(profile)) != null) {
                        this.extractMap(target, map, wildcardPatterns);
                    }
                    if ((ndx = profile.indexOf(46)) == -1) continue block0;
                    profile = profile.substring(0, ndx);
                }
            }
        }
        this.extractMap(target, this.baseProperties, wildcardPatterns);
    }

    protected void extractMap(Map target, Map<String, PropsEntry> map, String[] wildcardPatterns) {
        for (Map.Entry<String, PropsEntry> entry : map.entrySet()) {
            String key = entry.getKey();
            if (wildcardPatterns != null && Wildcard.matchOne((String)key, (String[])wildcardPatterns) == -1 || target.containsKey(key)) continue;
            target.put(key, entry.getValue().getValue());
        }
    }
}

