/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.orm;

public class DbNameUtil {
    public static String convertClassNameToTableName(Class clazz, boolean toUpperCase) {
        return DbNameUtil.convertClassNameToTableName(clazz, null, null, toUpperCase);
    }

    public static String convertClassNameToTableName(Class clazz, String tablePrefix, String tableSuffix, boolean toUpperCase) {
        return DbNameUtil.convertClassNameToTableName(clazz.getSimpleName(), tablePrefix, tableSuffix, toUpperCase);
    }

    public static String convertClassNameToTableName(String className, boolean toUpperCase) {
        return DbNameUtil.convertClassNameToTableName(className, null, null, toUpperCase);
    }

    public static String convertClassNameToTableName(String className, String tablePrefix, String tableSuffix, boolean toUpperCase) {
        StringBuilder tableName = new StringBuilder(className.length() + 10);
        if (tablePrefix != null) {
            tableName.append(tablePrefix);
        }
        for (int i = 0; i < className.length(); ++i) {
            char c = className.charAt(i);
            if (i != 0 && Character.isUpperCase(c)) {
                tableName.append('_');
            }
            if (toUpperCase) {
                tableName.append(Character.toUpperCase(c));
                continue;
            }
            tableName.append(Character.toLowerCase(c));
        }
        if (tableSuffix != null) {
            tableName.append(tableSuffix);
        }
        return tableName.toString();
    }

    public static String convertTableNameToClassName(String tableName, String tablePrefix, String tableSuffix) {
        StringBuilder className = new StringBuilder(tableName.length());
        int i = 0;
        int len = tableName.length();
        if (tablePrefix != null && tableName.startsWith(tablePrefix)) {
            i = tablePrefix.length();
        }
        if (tableSuffix != null && tableName.endsWith(tableSuffix)) {
            len -= tableSuffix.length();
        }
        boolean toUpper = true;
        while (i < len) {
            char c = tableName.charAt(i);
            if (c == '_') {
                toUpper = true;
            } else if (toUpper) {
                className.append(Character.toUpperCase(c));
                toUpper = false;
            } else {
                className.append(Character.toLowerCase(c));
            }
            ++i;
        }
        return className.toString();
    }

    public static String convertPropertyNameToColumnName(String propertyName, boolean toUpperCase) {
        StringBuilder tableName = new StringBuilder(propertyName.length() + 10);
        for (int i = 0; i < propertyName.length(); ++i) {
            char c = propertyName.charAt(i);
            if (i != 0 && Character.isUpperCase(c)) {
                tableName.append('_');
            }
            if (toUpperCase) {
                tableName.append(Character.toUpperCase(c));
                continue;
            }
            tableName.append(Character.toLowerCase(c));
        }
        return tableName.toString();
    }

    public static String convertColumnNameToPropertyName(String columnName) {
        StringBuilder propertyName = new StringBuilder(columnName.length());
        boolean toUpper = false;
        for (int i = 0; i < columnName.length(); ++i) {
            char c = columnName.charAt(i);
            if (c == '_') {
                toUpper = true;
                continue;
            }
            if (toUpper) {
                propertyName.append(Character.toUpperCase(c));
                toUpper = false;
                continue;
            }
            propertyName.append(Character.toLowerCase(c));
        }
        return propertyName.toString();
    }
}

