/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.orm.sqlgen;

import jodd.bean.BeanUtil;
import jodd.db.orm.DbEntityDescriptor;
import jodd.db.orm.DbNameUtil;
import jodd.db.orm.DbOrmManager;
import jodd.db.orm.sqlgen.DbSqlBuilder;
import jodd.util.StringUtil;

public class DbEntitySql {
    private static final String DELETE_FROM = "delete from ";
    private static final String WHERE = " where ";
    private static final String UPDATE = "update ";
    private static final String SELECT = "select ";
    private static final String FROM = " from ";
    private static final String SET = " set ";
    private static final String SELECT_COUNT_1_FROM = "select count(1) from ";

    public static DbSqlBuilder insert(Object entity) {
        return DbSqlBuilder.sql().insert(entity);
    }

    public static DbSqlBuilder truncate(Object entity) {
        return DbSqlBuilder.sql()._(DELETE_FROM).table(entity, null);
    }

    public static DbSqlBuilder update(Object entity) {
        String tableRef = DbEntitySql.createTableRefName(entity);
        return DbSqlBuilder.sql()._(UPDATE).table(entity, tableRef).set(tableRef, entity)._(WHERE).matchIds(tableRef, entity);
    }

    public static DbSqlBuilder updateAll(Object entity) {
        String tableRef = DbEntitySql.createTableRefName(entity);
        return DbSqlBuilder.sql()._(UPDATE).table(entity, tableRef).setAll(tableRef, entity)._(WHERE).matchIds(tableRef, entity);
    }

    public static DbSqlBuilder updateColumn(Object entity, String columnRef, Object value) {
        String tableRef = DbEntitySql.createTableRefName(entity);
        return DbSqlBuilder.sql()._(UPDATE).table(entity, tableRef)._(SET).column(tableRef, columnRef)._("=").colvalue(value)._(WHERE).matchIds(tableRef, entity);
    }

    public static DbSqlBuilder delete(Object entity) {
        String tableRef = DbEntitySql.createTableRefName(entity);
        return DbSqlBuilder.sql()._(DELETE_FROM).table(entity, null)._(WHERE).match(tableRef, entity);
    }

    public static DbSqlBuilder deleteByAll(Object entity) {
        String tableRef = DbEntitySql.createTableRefName(entity);
        return DbSqlBuilder.sql()._(DELETE_FROM).table(entity, null)._(WHERE).matchAll(tableRef, entity);
    }

    public static DbSqlBuilder deleteById(Object entity) {
        String tableRef = DbEntitySql.createTableRefName(entity);
        return DbSqlBuilder.sql()._(DELETE_FROM).table(entity, null)._(WHERE).matchIds(tableRef, entity);
    }

    public static DbSqlBuilder deleteById(Object entityType, Number id) {
        String tableRef = DbEntitySql.createTableRefName(entityType);
        return DbSqlBuilder.sql()._(DELETE_FROM).table(entityType, null)._(WHERE).refId(tableRef)._("=").colvalue(id);
    }

    public static DbSqlBuilder from(Object entity) {
        return DbEntitySql.from(entity, DbEntitySql.createTableRefName(entity));
    }

    public static DbSqlBuilder from(Object entity, String tableRef) {
        return DbSqlBuilder.sql()._(SELECT).column(tableRef)._(FROM).table(entity, tableRef)._(" ");
    }

    public static DbSqlBuilder find(Object entity) {
        String tableRef = DbEntitySql.createTableRefName(entity);
        return DbSqlBuilder.sql()._(SELECT).column(tableRef)._(FROM).table(entity, tableRef)._(WHERE).match(tableRef, entity);
    }

    public static DbSqlBuilder findByAll(Object entity) {
        String tableRef = DbEntitySql.createTableRefName(entity);
        return DbSqlBuilder.sql()._(SELECT).column(tableRef)._(FROM).table(entity, tableRef)._(WHERE).matchAll(tableRef, entity);
    }

    public static DbSqlBuilder findByColumn(Class entity, String column, Object value) {
        String tableRef = DbEntitySql.createTableRefName(entity);
        return DbSqlBuilder.sql()._(SELECT).column(tableRef)._(FROM).table(entity, tableRef)._(WHERE).ref(tableRef, column)._("=").colvalue(value);
    }

    public static DbSqlBuilder findForeign(Class entity, Object value) {
        String tableRef = DbEntitySql.createTableRefName(entity);
        DbOrmManager dbOrmManager = DbOrmManager.getInstance();
        DbEntityDescriptor dedFk = dbOrmManager.lookupType(value.getClass());
        String fkColum = StringUtil.uncapitalize((String)DbNameUtil.convertTableNameToClassName(dedFk.getTableName(), dbOrmManager.getTableNamePrefix(), dbOrmManager.getTableNameSuffix())) + StringUtil.capitalize((String)DbNameUtil.convertColumnNameToPropertyName(dedFk.getIdColumnName()));
        Object idValue = BeanUtil.getDeclaredPropertySilently((Object)value, (String)dedFk.getIdPropertyName());
        return DbSqlBuilder.sql()._(SELECT).column(tableRef)._(FROM).table(entity, tableRef)._(WHERE).ref(tableRef, fkColum)._("=").colvalue(idValue);
    }

    public static DbSqlBuilder findById(Object entity) {
        String tableRef = DbEntitySql.createTableRefName(entity);
        return DbSqlBuilder.sql()._(SELECT).column(tableRef)._(FROM).table(entity, tableRef)._(WHERE).matchIds(tableRef, entity);
    }

    public static DbSqlBuilder findById(Object entityType, Number id) {
        String tableRef = DbEntitySql.createTableRefName(entityType);
        return DbSqlBuilder.sql()._(SELECT).column(tableRef)._(FROM).table(entityType, tableRef)._(WHERE).refId(tableRef)._("=").colvalue(id);
    }

    public static DbSqlBuilder count(Object entity) {
        String tableRef = DbEntitySql.createTableRefName(entity);
        return DbSqlBuilder.sql()._(SELECT_COUNT_1_FROM).table(entity, tableRef)._(WHERE).match(tableRef, entity);
    }

    public static DbSqlBuilder count(Class entityType) {
        String tableRef = DbEntitySql.createTableRefName(entityType);
        return DbSqlBuilder.sql()._(SELECT_COUNT_1_FROM).table(entityType, tableRef);
    }

    public static DbSqlBuilder countAll(Object entity) {
        String tableRef = DbEntitySql.createTableRefName(entity);
        return DbSqlBuilder.sql()._(SELECT_COUNT_1_FROM).table(entity, tableRef)._(WHERE).matchAll(tableRef, entity);
    }

    protected static String createTableRefName(Object entity) {
        Class type = entity.getClass();
        type = type == Class.class ? (Class)entity : type;
        return type.getSimpleName();
    }
}

