/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.interceptor;

import jodd.madvoc.ActionRequest;
import jodd.madvoc.interceptor.ActionInterceptor;

public class EchoInterceptor
extends ActionInterceptor {
    public Object intercept(ActionRequest actionRequest) throws Exception {
        this.printBefore(actionRequest);
        long startTime = System.currentTimeMillis();
        Object result = null;
        try {
            result = actionRequest.invoke();
        }
        catch (Exception ex) {
            result = "<exception>";
            throw ex;
        }
        catch (Throwable th) {
            result = "<throwable>";
            throw new Exception(th);
        }
        finally {
            long executionTime = System.currentTimeMillis() - startTime;
            this.printAfter(actionRequest, executionTime, result);
        }
        return result;
    }

    protected void printBefore(ActionRequest request) {
        StringBuilder message = new StringBuilder("----->");
        message.append(request.getActionPath()).append("   [").append(request.getActionConfig().getActionString()).append(']');
        this.out(message.toString());
    }

    protected void printAfter(ActionRequest request, long executionTime, Object result) {
        StringBuilder message = new StringBuilder("<----- ");
        message.append(request.getActionPath()).append("  (").append(result);
        message.append(") in ").append(executionTime).append("ms.");
        this.out(message.toString());
    }

    protected void out(String message) {
        System.out.println(message);
    }
}

