/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.result;

import java.io.File;
import java.io.IOException;
import jodd.io.FileNameUtil;
import jodd.io.FileUtil;
import jodd.madvoc.MadvocException;
import jodd.util.MimeTypes;

public class RawResultData {
    private static final String RESULT = "raw:";
    protected final byte[] bytes;
    protected final String mime;

    public RawResultData(byte[] bytes, String type) {
        this.bytes = bytes;
        this.mime = MimeTypes.getMimeType((String)type);
    }

    public RawResultData(byte[] bytes) {
        this.bytes = bytes;
        this.mime = "application/octet-stream";
    }

    public RawResultData(File file) {
        try {
            this.bytes = FileUtil.readBytes((File)file);
        }
        catch (IOException ioex) {
            throw new MadvocException("Unable to read file '" + file + "'.", ioex);
        }
        String extension = FileNameUtil.getExtension((String)file.getAbsolutePath());
        this.mime = MimeTypes.getMimeType((String)extension);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String getMime() {
        return this.mime;
    }

    public String toString() {
        return RESULT;
    }
}

