/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite;

import jodd.petite.PetiteException;
import jodd.petite.WiringMode;
import jodd.petite.scope.DefaultScope;
import jodd.petite.scope.Scope;
import jodd.petite.scope.SingletonScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PetiteConfig {
    protected Class<? extends Scope> defaultScope = SingletonScope.class;
    protected WiringMode defaultWiringMode = WiringMode.STRICT;
    protected boolean detectDuplicatedBeanNames = false;
    protected boolean defaultRunInitMethods = true;
    protected boolean resolveReferenceParameters = true;

    public Class<? extends Scope> getDefaultScope() {
        return this.defaultScope;
    }

    public void setDefaultScope(Class<? extends Scope> defaultScope) {
        if (defaultScope == DefaultScope.class) {
            throw new PetiteException("Invalid default Petite scope: scope must be a concrete scope implementation.");
        }
        if (defaultScope == null) {
            throw new PetiteException("Invalid default Petite scope: null.");
        }
        this.defaultScope = defaultScope;
    }

    public WiringMode getDefaultWiringMode() {
        return this.defaultWiringMode;
    }

    public void setDefaultWiringMode(WiringMode defaultWiringMode) {
        if (defaultWiringMode == null || defaultWiringMode == WiringMode.DEFAULT) {
            throw new PetiteException("Invalid default wiring mode: " + (Object)((Object)defaultWiringMode));
        }
        this.defaultWiringMode = defaultWiringMode;
    }

    protected WiringMode resolveWiringMode(WiringMode wiringMode) {
        if (wiringMode == null || wiringMode == WiringMode.DEFAULT) {
            wiringMode = this.defaultWiringMode;
        }
        return wiringMode;
    }

    public boolean getDetectDuplicatedBeanNames() {
        return this.detectDuplicatedBeanNames;
    }

    public void setDetectDuplicatedBeanNames(boolean detectDuplicatedBeanNames) {
        this.detectDuplicatedBeanNames = detectDuplicatedBeanNames;
    }

    public boolean getDefaultRunInitMethods() {
        return this.defaultRunInitMethods;
    }

    public void setDefaultRunInitMethods(boolean defaultRunInitMethods) {
        this.defaultRunInitMethods = defaultRunInitMethods;
    }

    public boolean getResolveReferenceParameters() {
        return this.resolveReferenceParameters;
    }

    public void setResolveReferenceParameters(boolean resolveReferenceParameters) {
        this.resolveReferenceParameters = resolveReferenceParameters;
    }
}

