/*
 * Decompiled with CFR 0.152.
 */
package jodd.proxetta;

import java.io.InputStream;
import jodd.JoddDefault;
import jodd.proxetta.ProxettaException;
import jodd.proxetta.ProxyAspect;
import jodd.proxetta.asm.ProxettaCreator;
import jodd.util.ClassLoaderUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Proxetta {
    protected final ProxyAspect[] aspects;
    protected boolean forced;
    protected ClassLoader classLoader;
    protected boolean variableClassName;
    protected String classNameSuffix = "$Proxetta";

    public Proxetta(ProxyAspect ... aspects) {
        this.aspects = aspects;
    }

    public static Proxetta withAspects(ProxyAspect ... aspects) {
        return new Proxetta(aspects);
    }

    public Proxetta forced(boolean forced) {
        this.forced = forced;
        return this;
    }

    public Proxetta loadsWith(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public Proxetta variableClassName() {
        this.variableClassName = true;
        return this;
    }

    public Proxetta constantClassName() {
        this.variableClassName = false;
        return this;
    }

    public Proxetta useClassNameSuffix(String suffix) {
        this.classNameSuffix = suffix;
        return this;
    }

    public Proxetta useDefaultClassNameSuffix() {
        this.classNameSuffix = "$Proxetta";
        return this;
    }

    public Proxetta dontUseClassNameSuffix() {
        this.classNameSuffix = null;
        return this;
    }

    protected ProxettaCreator createProxettaCreator() {
        ProxettaCreator pc = new ProxettaCreator(this.aspects);
        pc.setUseVariableClassName(this.variableClassName);
        pc.setClassNameSuffix(this.classNameSuffix);
        return pc;
    }

    public byte[] createProxy(Class target) {
        return this.createProxy(target, null);
    }

    public byte[] createProxy(Class target, String proxyClassName) {
        return this.createProxy(this.createProxettaCreator().accept(target, proxyClassName));
    }

    public byte[] createProxy(String targetName) {
        return this.createProxy(targetName, null);
    }

    public byte[] createProxy(String targetName, String proxyClassName) {
        return this.createProxy(this.createProxettaCreator().accept(targetName, proxyClassName));
    }

    public byte[] createProxy(InputStream in) {
        return this.createProxy(in, null);
    }

    public byte[] createProxy(InputStream in, String proxyClassName) {
        return this.createProxy(this.createProxettaCreator().accept(in, proxyClassName));
    }

    protected byte[] createProxy(ProxettaCreator pc) {
        byte[] result = pc.toByteArray();
        if (!this.forced && !pc.isProxyApplied()) {
            return null;
        }
        return result;
    }

    public Class defineProxy(Class target) {
        return this.defineProxy(target, null);
    }

    public Class defineProxy(Class target, String proxyClassName) {
        ProxettaCreator pc = this.createProxettaCreator();
        pc.accept(target, proxyClassName);
        if (!this.forced && !pc.isProxyApplied()) {
            return target;
        }
        try {
            if (this.classLoader == null) {
                ClassLoader cl = target.getClassLoader();
                if (cl == null) {
                    cl = JoddDefault.classLoader;
                }
                return ClassLoaderUtil.defineClass((String)pc.getProxyClassName(), (byte[])pc.toByteArray(), (ClassLoader)cl);
            }
            return ClassLoaderUtil.defineClass((String)pc.getProxyClassName(), (byte[])pc.toByteArray(), (ClassLoader)this.classLoader);
        }
        catch (Exception ex) {
            throw new ProxettaException("Proxy class definition was unsuccessful.", ex);
        }
    }

    public Class defineProxy(String targetName) {
        return this.defineProxy(targetName, null);
    }

    public Class defineProxy(String targetName, String proxyClassName) {
        ProxettaCreator pc = this.createProxettaCreator();
        pc.accept(targetName, proxyClassName);
        if (!this.forced && !pc.isProxyApplied()) {
            try {
                return ClassLoaderUtil.loadClass((String)targetName, Proxetta.class);
            }
            catch (ClassNotFoundException cnfex) {
                throw new ProxettaException(cnfex);
            }
        }
        try {
            if (this.classLoader == null) {
                return ClassLoaderUtil.defineClass((String)pc.getProxyClassName(), (byte[])pc.toByteArray());
            }
            return ClassLoaderUtil.defineClass((String)pc.getProxyClassName(), (byte[])pc.toByteArray(), (ClassLoader)this.classLoader);
        }
        catch (Exception ex) {
            throw new ProxettaException("Proxy class definition was unsuccessful.", ex);
        }
    }

    public <T> T createProxyInstance(Class<T> target) {
        return this.createProxyInstance(target, null);
    }

    public <T> T createProxyInstance(Class<T> target, String proxyClassName) {
        Class c = this.defineProxy(target, proxyClassName);
        try {
            return c.newInstance();
        }
        catch (Exception ex) {
            throw new ProxettaException("Unable to create new proxy instance.", ex);
        }
    }

    public Object createProxyInstance(String targetName) {
        return this.createProxyInstance(targetName, null);
    }

    public Object createProxyInstance(String targetName, String proxyClassName) {
        Class c = this.defineProxy(targetName, proxyClassName);
        try {
            return c.newInstance();
        }
        catch (Exception ex) {
            throw new ProxettaException("Unable to create new proxy instance.", ex);
        }
    }
}

