/*
 * Decompiled with CFR 0.152.
 */
package jodd.proxetta.asm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jodd.asm.EmptyAnnotationVisitor;
import jodd.proxetta.AnnotationInfo;
import jodd.proxetta.asm.ProxettaAsmUtil;
import org.objectweb.asm.AnnotationVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationReader
extends EmptyAnnotationVisitor
implements AnnotationInfo {
    protected final String desc;
    protected final String className;
    protected final boolean visible;
    protected final Map<String, Object> elements;

    public AnnotationReader(String desc, boolean visible) {
        this.desc = desc;
        this.visible = visible;
        this.elements = new HashMap<String, Object>();
        this.className = ProxettaAsmUtil.typeref2Name(desc);
    }

    @Override
    public String getAnnotationClassname() {
        return this.className;
    }

    @Override
    public String getAnnotationSignature() {
        return this.desc;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public Object getElement(String name) {
        return this.elements.get(name);
    }

    @Override
    public Set<String> getElementNames() {
        return this.elements.keySet();
    }

    @Override
    public void visit(String name, Object value) {
        this.elements.put(name, value);
    }

    @Override
    public void visitEnum(String name, String desc, String value) {
        this.elements.put(name, new String[]{desc, value});
    }

    @Override
    public AnnotationVisitor visitAnnotation(String name, String desc) {
        AnnotationReader nestedAnnotation = new AnnotationReader(desc, true);
        this.elements.put(name, nestedAnnotation);
        return nestedAnnotation;
    }

    @Override
    public AnnotationVisitor visitArray(final String name) {
        final ArrayList array = new ArrayList();
        return new EmptyAnnotationVisitor(){

            public void visit(String name2, Object value) {
                array.add(value);
            }

            public void visitEnd() {
                Object[] data = array.toArray(new Object[array.size()]);
                AnnotationReader.this.elements.put(name, data);
            }
        };
    }
}

