/*
 * Decompiled with CFR 0.152.
 */
package jodd.db;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jodd.db.DbSqlException;
import jodd.util.StringUtil;
import jodd.util.collection.IntArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DbQueryParser {
    public static final String SQL_SEPARATORS = " \n\r\f\t,()=<>&|+-=/*'^![]#~\\";
    boolean prepared;
    String sql;
    private Map<String, IntArrayList> namedParameterLocationMap;

    DbQueryParser() {
    }

    DbQueryParser(String sql) {
        this.parseSql(sql);
    }

    private void storeNamedParameter(String name, int position) {
        IntArrayList locations = this.namedParameterLocationMap.get(name);
        if (locations == null) {
            locations = new IntArrayList();
            this.namedParameterLocationMap.put(name, locations);
        }
        locations.add(position);
    }

    IntArrayList lookupNamedParameterIndices(String name) {
        return this.namedParameterLocationMap.get(name);
    }

    IntArrayList getNamedParameterIndices(String name) {
        IntArrayList positions = this.namedParameterLocationMap.get(name);
        if (positions == null) {
            throw new DbSqlException("Named parameter '" + name + "' not found.");
        }
        return positions;
    }

    Iterator<String> iterateNamedParameters() {
        return this.namedParameterLocationMap.keySet().iterator();
    }

    void parseSql(String sqlString) {
        this.namedParameterLocationMap = new HashMap<String, IntArrayList>();
        int stringLength = sqlString.length();
        StringBuilder pureSql = new StringBuilder(stringLength);
        boolean inQuote = false;
        int index = 0;
        int paramCount = 0;
        while (index < stringLength) {
            char c = sqlString.charAt(index);
            if (inQuote) {
                if (c == '\'') {
                    inQuote = false;
                }
            } else if (c == '\'') {
                inQuote = true;
            } else {
                String param;
                int right;
                if (c == ':') {
                    right = StringUtil.indexOfChars((String)sqlString, (String)SQL_SEPARATORS, (int)(index + 1));
                    if (right < 0) {
                        right = stringLength;
                    }
                    param = sqlString.substring(index + 1, right);
                    this.storeNamedParameter(param, ++paramCount);
                    pureSql.append('?');
                    index = right;
                    continue;
                }
                if (c == '?') {
                    if (index < stringLength - 1 && Character.isDigit(sqlString.charAt(index + 1))) {
                        right = StringUtil.indexOfChars((String)sqlString, (String)SQL_SEPARATORS, (int)(index + 1));
                        if (right < 0) {
                            right = stringLength;
                        }
                        param = sqlString.substring(index + 1, right);
                        try {
                            Integer.parseInt(param);
                        }
                        catch (NumberFormatException nfex) {
                            throw new DbSqlException("Positional parameter '" + nfex + "' is not an integral ordinal.", nfex);
                        }
                        this.storeNamedParameter(param, ++paramCount);
                        pureSql.append('?');
                        index = right;
                        continue;
                    }
                    ++paramCount;
                }
            }
            pureSql.append(c);
            ++index;
        }
        this.prepared = paramCount != 0;
        this.sql = pureSql.toString();
    }
}

