/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.orm.sqlgen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jodd.db.orm.ColumnAliasType;
import jodd.db.orm.ColumnData;
import jodd.db.orm.DbEntityColumnDescriptor;
import jodd.db.orm.DbEntityDescriptor;
import jodd.db.orm.DbOrmManager;
import jodd.db.orm.sqlgen.DbSqlBuilderException;
import jodd.db.orm.sqlgen.ParameterValue;

public abstract class TemplateData {
    private static final String COL_CODE_PREFIX = "col_";
    public final DbOrmManager dbOrmManager = DbOrmManager.getInstance();
    protected Map<String, Object> objectRefs;
    protected Map<String, TableRefData> tableRefs;
    protected Map<String, ColumnData> columnData;
    protected int columnCount;
    protected ColumnAliasType columnAliasType = this.dbOrmManager.getDefaultColumnAliasType();
    protected Map<String, ParameterValue> parameters;
    protected int paramCount;
    public int hintCount;
    protected List<String> hints;
    public DbEntityColumnDescriptor lastColumnDec;

    protected TemplateData() {
    }

    public DbOrmManager getDbOrmManager() {
        return this.dbOrmManager;
    }

    protected void resetOnPreInit() {
        this.columnCount = 0;
        this.paramCount = 0;
        this.hintCount = 0;
    }

    protected void resetAll() {
        this.resetOnPreInit();
        if (this.tableRefs != null) {
            this.tableRefs.clear();
        }
        if (this.columnData != null) {
            this.columnData.clear();
        }
        if (this.parameters != null) {
            this.parameters.clear();
        }
        if (this.hints != null) {
            this.hints.clear();
        }
        this.columnAliasType = this.dbOrmManager.getDefaultColumnAliasType();
    }

    public void setObjectReference(String name, Object object) {
        if (this.objectRefs == null) {
            this.objectRefs = new HashMap<String, Object>();
        }
        this.objectRefs.put(name, object);
    }

    public Object getObjectReference(String name) {
        if (this.objectRefs == null) {
            return null;
        }
        return this.objectRefs.get(name);
    }

    public Object lookupObject(String ref) {
        Object value = this.getObjectReference(ref);
        if (value == null) {
            throw new DbSqlBuilderException("Invalid object reference: '" + ref + "'.");
        }
        return value;
    }

    public DbEntityDescriptor getTableDescriptor(String tableRef) {
        if (this.tableRefs == null) {
            return null;
        }
        TableRefData t = this.tableRefs.get(tableRef);
        return t == null ? null : t.desc;
    }

    public String getTableAlias(String tableRef) {
        if (this.tableRefs == null) {
            return null;
        }
        TableRefData t = this.tableRefs.get(tableRef);
        return t == null ? null : t.alias;
    }

    public void registerTableReference(String tableReference, DbEntityDescriptor ded, String tableAlias) {
        TableRefData t;
        if (this.tableRefs == null) {
            this.tableRefs = new HashMap<String, TableRefData>();
        }
        if (this.tableRefs.put(tableReference, t = new TableRefData(ded, tableAlias)) != null) {
            throw new DbSqlBuilderException("Duplicated table reference detected: '" + tableReference + "'.");
        }
    }

    public ColumnAliasType getColumnAliasType() {
        return this.columnAliasType;
    }

    public void registerColumnDataForTableRef(String tableRef, String tableName) {
        if (this.columnData == null) {
            this.columnData = new HashMap<String, ColumnData>();
        }
        this.columnData.put(tableRef, new ColumnData(tableName));
    }

    public String registerColumnDataForColumnCode(String tableName, String column) {
        if (this.columnData == null) {
            this.columnData = new HashMap<String, ColumnData>();
        }
        String code = COL_CODE_PREFIX + Integer.toString(this.columnCount++) + '_';
        this.columnData.put(code, new ColumnData(tableName, column));
        return code;
    }

    public String getNextParameterName() {
        return "p" + this.paramCount++;
    }

    public void addParameter(String name, Object value, DbEntityColumnDescriptor dec) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, ParameterValue>();
        }
        this.parameters.put(name, new ParameterValue(value, dec));
    }

    protected DbEntityDescriptor lookupName(String entityName) {
        DbEntityDescriptor ded = this.dbOrmManager.lookupName(entityName);
        if (ded == null) {
            throw new DbSqlBuilderException("Entity name '" + entityName + "' is not registered with DbOrmManager.");
        }
        return ded;
    }

    protected DbEntityDescriptor lookupType(Class entity) {
        DbEntityDescriptor ded = this.dbOrmManager.lookupType(entity);
        if (ded == null) {
            throw new DbSqlBuilderException("Invalid or not-persistent entity type: '" + entity.getName() + "'.");
        }
        return ded;
    }

    protected DbEntityDescriptor lookupTableRef(String tableRef) {
        DbEntityDescriptor ded = this.getTableDescriptor(tableRef);
        if (ded == null) {
            throw new DbSqlBuilderException("Invalid table reference: '" + tableRef + "', not used in this query.");
        }
        return ded;
    }

    protected void defineParameter(StringBuilder query, String name, Object value) {
        if (name == null) {
            name = this.getNextParameterName();
        }
        query.append(':').append(name);
        this.addParameter(name, value, null);
    }

    public void registerHint(String hint) {
        if (this.hints == null) {
            this.hints = new ArrayList<String>(this.hintCount);
        }
        this.hints.add(hint);
    }

    private static final class TableRefData {
        final String alias;
        final DbEntityDescriptor desc;

        private TableRefData(DbEntityDescriptor desc, String alias) {
            this.alias = alias;
            this.desc = desc;
        }
    }
}

