/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.orm.sqlgen.chunks;

import jodd.bean.BeanUtil;
import jodd.db.orm.DbEntityColumnDescriptor;
import jodd.db.orm.DbEntityDescriptor;
import jodd.db.orm.sqlgen.chunks.SqlChunk;
import jodd.util.StringUtil;

public class InsertChunk
extends SqlChunk {
    protected final String entityName;
    protected final Class entityType;
    protected final Object data;

    public InsertChunk(String entityName, Object data) {
        this(entityName, null, data);
    }

    public InsertChunk(Class entityType, Object data) {
        this(null, entityType, data);
    }

    protected InsertChunk(String entityName, Class entityType, Object data) {
        super(5);
        this.entityName = entityName;
        this.entityType = entityType;
        this.data = data;
    }

    public void process(StringBuilder out) {
        DbEntityDescriptor ded = this.entityName != null ? this.lookupName(this.entityName) : this.lookupType(this.entityType);
        StringBuilder col = new StringBuilder();
        StringBuilder val = new StringBuilder();
        DbEntityColumnDescriptor[] decList = ded.getColumnDescriptors();
        String typeName = StringUtil.uncapitalize((String)ded.getEntityName());
        int size = 0;
        for (DbEntityColumnDescriptor dec : decList) {
            String property = dec.getPropertyName();
            Object value = BeanUtil.getDeclaredProperty((Object)this.data, (String)property);
            if (value == null) continue;
            if (size > 0) {
                col.append(',').append(' ');
                val.append(',').append(' ');
            }
            ++size;
            col.append(dec.getColumnName());
            String propertyName = typeName + '.' + property;
            this.defineParameter(val, propertyName, value, dec);
        }
        out.append("insert into ").append(ded.getTableName()).append(" (").append((CharSequence)col).append(") values (").append((CharSequence)val).append(')');
    }

    public SqlChunk clone() {
        return new InsertChunk(this.entityName, this.entityType, this.data);
    }
}

