/*
 * Decompiled with CFR 0.152.
 */
package jodd.jtx;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import jodd.jtx.JtxException;
import jodd.jtx.JtxIsolationLevel;
import jodd.jtx.JtxResourceManager;
import jodd.jtx.JtxStatus;
import jodd.jtx.JtxTransaction;
import jodd.jtx.JtxTransactionMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JtxTransactionManager {
    private static final Logger log = LoggerFactory.getLogger(JtxTransactionManager.class);
    protected int maxResourcesPerTransaction = -1;
    protected boolean oneResourceManager;
    protected boolean validateExistingTransaction;
    protected Map<Class, JtxResourceManager> resourceManagers;
    protected final ThreadLocal<LinkedList<JtxTransaction>> txStack = new ThreadLocal<LinkedList<JtxTransaction>>(){

        @Override
        protected synchronized LinkedList<JtxTransaction> initialValue() {
            return new LinkedList<JtxTransaction>();
        }
    };
    protected int totalTransactions;

    public JtxTransactionManager() {
        this.resourceManagers = new HashMap<Class, JtxResourceManager>();
    }

    public int getMaxResourcesPerTransaction() {
        return this.maxResourcesPerTransaction;
    }

    public void setMaxResourcesPerTransaction(int maxResourcesPerTransaction) {
        this.maxResourcesPerTransaction = maxResourcesPerTransaction;
    }

    public boolean isValidateExistingTransaction() {
        return this.validateExistingTransaction;
    }

    public void setValidateExistingTransaction(boolean validateExistingTransaction) {
        this.validateExistingTransaction = validateExistingTransaction;
    }

    public boolean isSingleResourceManager() {
        return this.oneResourceManager;
    }

    public void setSingleResourceManager(boolean oneResourceManager) {
        this.oneResourceManager = oneResourceManager;
    }

    public int totalThreadTransactions() {
        return this.txStack.get().size();
    }

    public int totalThreadTransactionsWithStatus(JtxStatus status) {
        LinkedList<JtxTransaction> txlist = this.txStack.get();
        int count = 0;
        for (JtxTransaction tx : txlist) {
            if (tx.getStatus() != status) continue;
            ++count;
        }
        return count;
    }

    public int totalActiveThreadTransactions() {
        return this.totalThreadTransactionsWithStatus(JtxStatus.STATUS_ACTIVE);
    }

    public boolean isAssociatedWithThread(JtxTransaction tx) {
        return this.txStack.get().contains(tx);
    }

    protected boolean removeTransaction(JtxTransaction tx) {
        --this.totalTransactions;
        return this.txStack.get().remove(tx);
    }

    public JtxTransaction getTransaction() {
        LinkedList<JtxTransaction> txlist = this.txStack.get();
        if (txlist.isEmpty()) {
            return null;
        }
        return txlist.getLast();
    }

    protected void associateTransaction(JtxTransaction tx) {
        ++this.totalTransactions;
        this.txStack.get().addLast(tx);
    }

    public int totalTransactions() {
        return this.totalTransactions;
    }

    protected JtxTransaction createNewTransaction(JtxTransactionMode tm, Object context) {
        return new JtxTransaction(this, tm, context);
    }

    public JtxTransaction requestTransaction(JtxTransactionMode mode) {
        return this.requestTransaction(mode, null);
    }

    public JtxTransaction requestTransaction(JtxTransactionMode mode, Object context) {
        JtxTransaction currentTx;
        if (log.isDebugEnabled()) {
            log.debug("Requesting TX " + mode.toString());
        }
        if (!this.checkValidTxContext(currentTx = this.getTransaction(), context)) {
            return currentTx;
        }
        switch (mode.getPropagationBehavior()) {
            case PROPAGATION_REQUIRED: {
                return this.propRequired(currentTx, mode, context);
            }
            case PROPAGATION_SUPPORTS: {
                return this.propSupports(currentTx, mode, context);
            }
            case PROPAGATION_MANDATORY: {
                return this.propMandatory(currentTx, mode, context);
            }
            case PROPAGATION_REQUIRES_NEW: {
                return this.propRequiresNew(currentTx, mode, context);
            }
            case PROPAGATION_NOT_SUPPORTED: {
                return this.propNotSupported(currentTx, mode, context);
            }
            case PROPAGATION_NEVER: {
                return this.propNever(currentTx, mode, context);
            }
        }
        throw new JtxException("Invalid transaction propagation value (" + mode.getPropagationBehavior().value() + ')');
    }

    protected boolean checkValidTxContext(JtxTransaction currentTx, Object destContext) {
        if (currentTx == null) {
            return true;
        }
        if (destContext == null) {
            return true;
        }
        if (currentTx.getContext() == null) {
            return true;
        }
        return !destContext.equals(currentTx.getContext());
    }

    protected void continueTx(JtxTransaction sourceTx, JtxTransactionMode destMode) {
        JtxIsolationLevel currentIsolationLevel;
        if (!this.validateExistingTransaction) {
            return;
        }
        JtxTransactionMode sourceMode = sourceTx.getTransactionMode();
        JtxIsolationLevel destIsolationLevel = destMode.getIsolationLevel();
        if (destIsolationLevel != JtxIsolationLevel.ISOLATION_DEFAULT && (currentIsolationLevel = sourceMode.getIsolationLevel()) != destIsolationLevel) {
            throw new JtxException("Participating transaction specifies isolation level '" + (Object)((Object)destIsolationLevel) + "' which is incompatible with existing transaction: '" + (Object)((Object)currentIsolationLevel) + "'.");
        }
        if (!destMode.isReadOnly() && sourceMode.isReadOnly()) {
            throw new JtxException("Participating transaction is not marked as read-only, but existing transaction is.");
        }
    }

    protected JtxTransaction propRequired(JtxTransaction currentTx, JtxTransactionMode mode, Object context) {
        if (currentTx == null || currentTx.isNoTransaction()) {
            currentTx = this.createNewTransaction(mode, context);
        } else {
            this.continueTx(currentTx, mode);
        }
        return currentTx;
    }

    protected JtxTransaction propRequiresNew(JtxTransaction currentTx, JtxTransactionMode mode, Object context) {
        return this.createNewTransaction(mode, context);
    }

    protected JtxTransaction propSupports(JtxTransaction currentTx, JtxTransactionMode mode, Object context) {
        if (currentTx != null && !currentTx.isNoTransaction()) {
            this.continueTx(currentTx, mode);
        }
        if (currentTx == null) {
            currentTx = this.createNewTransaction(mode, context);
        }
        return currentTx;
    }

    protected JtxTransaction propMandatory(JtxTransaction currentTx, JtxTransactionMode mode, Object context) {
        if (currentTx == null || currentTx.isNoTransaction()) {
            throw new JtxException("No existing transaction found for transaction marked with propagation 'mandatory'.");
        }
        this.continueTx(currentTx, mode);
        return currentTx;
    }

    protected JtxTransaction propNotSupported(JtxTransaction currentTx, JtxTransactionMode mode, Object context) {
        if (currentTx == null) {
            return this.createNewTransaction(mode, context);
        }
        if (currentTx.isNoTransaction()) {
            return currentTx;
        }
        return this.createNewTransaction(mode, context);
    }

    protected JtxTransaction propNever(JtxTransaction currentTx, JtxTransactionMode mode, Object context) {
        if (currentTx != null && !currentTx.isNoTransaction()) {
            throw new JtxException("Existing transaction found for transaction marked with propagation 'never'.");
        }
        if (currentTx == null) {
            currentTx = this.createNewTransaction(mode, context);
        }
        return currentTx;
    }

    public void registerResourceManager(JtxResourceManager resourceManager) {
        if (this.oneResourceManager && !this.resourceManagers.isEmpty()) {
            throw new JtxException("Transaction manager allows only one resource manager.");
        }
        this.resourceManagers.put(resourceManager.getResourceType(), resourceManager);
    }

    protected <E> JtxResourceManager<E> lookupResourceManager(Class<E> resourceType) {
        JtxResourceManager resourceManager = this.resourceManagers.get(resourceType);
        if (resourceManager == null) {
            throw new JtxException("No registered resource manager for resource type: '" + resourceType.getSimpleName() + "'.");
        }
        return resourceManager;
    }

    public void close() {
        for (JtxResourceManager resourceManager : this.resourceManagers.values()) {
            try {
                resourceManager.close();
            }
            catch (Exception exception) {}
        }
        this.resourceManagers.clear();
    }
}

