/*
 * Decompiled with CFR 0.152.
 */
package jodd.jtx.proxy;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.jtx.JtxTransactionManager;
import jodd.jtx.JtxTransactionMode;
import jodd.jtx.meta.Transaction;
import jodd.jtx.worker.LeanTransactionWorker;
import jodd.proxetta.ProxettaException;
import jodd.util.StringUtil;

public class AnnotationTxAdviceManager {
    protected static final String JTXCTX_PATTERN_CLASS = "$class";
    protected static final String JTXCTX_PATTERN_METHOD = "$method";
    protected final Map<String, JtxTransactionMode> txmap = new HashMap<String, JtxTransactionMode>();
    protected final LeanTransactionWorker jtxWorker;
    protected final JtxTransactionMode defaultTransactionMode;
    protected final String contextPattern;

    public AnnotationTxAdviceManager(JtxTransactionManager jtxManager) {
        this(new LeanTransactionWorker(jtxManager));
    }

    public AnnotationTxAdviceManager(LeanTransactionWorker jtxWorker) {
        this(jtxWorker, "$class#$method", null);
    }

    public AnnotationTxAdviceManager(JtxTransactionManager jtxManager, String contextPattern) {
        this(new LeanTransactionWorker(jtxManager), contextPattern);
    }

    public AnnotationTxAdviceManager(LeanTransactionWorker jtxWorker, String contextPattern) {
        this(jtxWorker, contextPattern, null);
    }

    public AnnotationTxAdviceManager(JtxTransactionManager jtxManager, String contextPattern, JtxTransactionMode defaultTxMode) {
        this(new LeanTransactionWorker(jtxManager), contextPattern, defaultTxMode);
    }

    public AnnotationTxAdviceManager(LeanTransactionWorker jtxWorker, String contextPattern, JtxTransactionMode defaultTxMode) {
        this.jtxWorker = jtxWorker;
        this.defaultTransactionMode = defaultTxMode == null ? new JtxTransactionMode().propagationSupports() : defaultTxMode;
        this.contextPattern = contextPattern;
    }

    public LeanTransactionWorker getJtxWorker() {
        return this.jtxWorker;
    }

    public JtxTransactionMode getDefaultTransactionMode() {
        return this.defaultTransactionMode;
    }

    public String resolveContext(Class type, String methodName) {
        if (this.contextPattern == null) {
            return null;
        }
        String ctx = this.contextPattern;
        ctx = StringUtil.replace((String)ctx, (String)JTXCTX_PATTERN_CLASS, (String)type.getName());
        ctx = StringUtil.replace((String)ctx, (String)JTXCTX_PATTERN_METHOD, (String)methodName);
        return ctx;
    }

    public synchronized JtxTransactionMode getTxMode(Class type, String methodName, Class[] methodArgTypes, String unique) {
        String signature = type.getName() + '#' + methodName + '%' + unique;
        JtxTransactionMode txMode = this.txmap.get(signature);
        if (txMode == null && !this.txmap.containsKey(signature)) {
            ClassDescriptor cd = ClassIntrospector.lookup((Class)type);
            Method m = cd.getMethod(methodName, methodArgTypes);
            if (m == null) {
                throw new ProxettaException("Method '" + methodName + "'not found in class: " + type.getName());
            }
            Transaction txAnn = m.getAnnotation(Transaction.class);
            if (txAnn != null) {
                txMode = new JtxTransactionMode();
                txMode.setPropagationBehaviour(txAnn.propagation());
                txMode.setIsolationLevel(txAnn.isolation());
                txMode.setReadOnly(txAnn.readOnly());
            } else {
                txMode = this.defaultTransactionMode;
            }
            this.txmap.put(signature, txMode);
        }
        return txMode;
    }
}

