/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc;

import java.util.Properties;
import javax.servlet.ServletContext;
import jodd.madvoc.MadvocException;
import jodd.madvoc.WebApplication;
import jodd.madvoc.component.ActionsManager;
import jodd.madvoc.component.MadvocConfig;
import jodd.madvoc.component.MadvocController;
import jodd.madvoc.component.ResultsManager;
import jodd.madvoc.config.AutomagicMadvocConfigurator;
import jodd.madvoc.config.MadvocConfigurator;
import jodd.util.ClassLoaderUtil;
import jodd.util.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebApplicationStarter {
    private static Logger log;
    protected String webAppClass;
    protected String paramsFile;
    protected String madvocConfigurator;
    protected WebApplication webapp;
    protected MadvocController madvocController;
    protected MadvocConfig madvocConfig;

    public void setWebAppClass(String webAppClass) {
        this.webAppClass = webAppClass;
    }

    public void setParamsFile(String paramsFile) {
        this.paramsFile = paramsFile;
    }

    public void setMadvocConfigurator(String madvocConfigurator) {
        this.madvocConfigurator = madvocConfigurator;
    }

    public MadvocController getMadvocController() {
        return this.madvocController;
    }

    public MadvocConfig getMadvocConfig() {
        return this.madvocConfig;
    }

    public WebApplication startNewWebApplication(ServletContext context) {
        this.webapp = this.createWebApplication(this.webAppClass);
        log = LoggerFactory.getLogger(WebApplicationStarter.class);
        if (this.webAppClass == null) {
            log.info("Default web application created.");
        } else {
            log.info("Created web application: {}", (Object)this.webAppClass);
        }
        this.webapp.initWebApplication();
        Properties params = this.loadMadvocParams(this.paramsFile);
        this.webapp.defineParams(params);
        this.webapp.registerMadvocComponents();
        this.madvocConfig = this.webapp.getComponent(MadvocConfig.class);
        if (this.madvocConfig == null) {
            throw new MadvocException("No Madvoc configuration component found.");
        }
        this.webapp.init(this.madvocConfig, context);
        ActionsManager actionsManager = this.webapp.getComponent(ActionsManager.class);
        if (actionsManager == null) {
            throw new MadvocException("No Madvoc actions manager component found.");
        }
        this.webapp.initActions(actionsManager);
        ResultsManager resultsManager = this.webapp.getComponent(ResultsManager.class);
        if (resultsManager == null) {
            throw new MadvocException("No Madvoc results manager component found.");
        }
        this.webapp.initResults(resultsManager);
        MadvocConfigurator configurator = this.loadMadvocConfig(this.madvocConfigurator);
        this.webapp.configure(configurator);
        this.madvocController = this.webapp.getComponent(MadvocController.class);
        if (this.madvocController == null) {
            throw new MadvocException("No Madvoc controller component found.");
        }
        this.madvocController.init(context);
        return this.webapp;
    }

    protected WebApplication createWebApplication(String webAppClassName) {
        WebApplication webApp;
        if (this.webAppClass == null) {
            return new WebApplication();
        }
        try {
            Class webAppClass = ClassLoaderUtil.loadClass((String)webAppClassName, this.getClass());
            webApp = (WebApplication)webAppClass.newInstance();
        }
        catch (ClassNotFoundException cnfex) {
            throw new MadvocException("Madvoc web application class not found: " + webAppClassName, cnfex);
        }
        catch (ClassCastException ccex) {
            throw new MadvocException("Class '" + this.webAppClass + "' is not a Madvoc web application.", ccex);
        }
        catch (Exception ex) {
            throw new MadvocException("Unable to load Madvoc web application class '" + this.webAppClass + "': " + ex.toString(), ex);
        }
        return webApp;
    }

    protected Properties loadMadvocParams(String pattern) {
        if (pattern == null) {
            return new Properties();
        }
        log.info("Loading Madvoc parameters from: {}", (Object)pattern);
        try {
            return PropertiesUtil.createFromClasspath((String)pattern);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new MadvocException("Unable to load Madvoc parameters from: :" + pattern + ".properties': " + ex.toString(), ex);
        }
    }

    protected MadvocConfigurator loadMadvocConfig(String className) {
        MadvocConfigurator configurator;
        if (className == null) {
            log.info("Configuring Madvoc using default automagic configurator");
            return new AutomagicMadvocConfigurator();
        }
        log.info("Configuring Madvoc using configurator: {}", (Object)className);
        try {
            Class clazz = ClassLoaderUtil.loadClass((String)className, this.getClass());
            configurator = (MadvocConfigurator)clazz.newInstance();
        }
        catch (ClassCastException ccex) {
            ccex.printStackTrace();
            throw new MadvocException("Class '" + className + "' is not a Madvoc configurator.", ccex);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new MadvocException("Unable to load Madvoc configurator class '" + className + "': " + ex.toString(), ex);
        }
        return configurator;
    }
}

