/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.component;

import jodd.madvoc.ActionConfig;
import jodd.madvoc.MadvocException;
import jodd.madvoc.MadvocUtil;
import jodd.madvoc.component.ActionsManager;
import jodd.madvoc.component.MadvocConfig;
import jodd.petite.meta.PetiteInitMethod;
import jodd.petite.meta.PetiteInject;
import jodd.util.StringUtil;

public class ActionPathMapper {
    protected static final String FALLBACK_ACTION_METHOD_NAME = "view";
    protected String defaultMethodName1;
    protected String defaultMethodName2;
    @PetiteInject
    protected ActionsManager actionsManager;
    @PetiteInject
    protected MadvocConfig madvocConfig;

    @PetiteInitMethod(order=1, firstOff=true)
    void actionPathMapperInit() {
        String[] d = this.madvocConfig.getDefaultActionMethodNames();
        String method1 = null;
        String method2 = null;
        if (d != null) {
            if (d.length > 0) {
                method1 = d[0];
            }
            if (d.length > 1) {
                method2 = d[1];
            }
        }
        this.defaultMethodName1 = method1 == null ? FALLBACK_ACTION_METHOD_NAME : method1;
        this.defaultMethodName2 = method2 == null ? this.defaultMethodName1 : method2;
    }

    protected ActionConfig lookupActionConfig(String actionPath) {
        String packageRoot;
        ActionConfig cfg = this.actionsManager.lookup(actionPath);
        if (cfg == null && this.madvocConfig.isActionPathMappingEnabled() && (packageRoot = this.madvocConfig.getRootPackage()) != null) {
            this.registerActionPath(actionPath, packageRoot);
            cfg = this.actionsManager.lookup(actionPath);
        }
        if (cfg == null && this.madvocConfig.getSupplementAction() != null) {
            this.registerSupplementAction(actionPath);
            cfg = this.actionsManager.lookup(actionPath);
        }
        return cfg;
    }

    public ActionConfig resolveActionConfig(String actionPath, String method) {
        ActionConfig actionConfig = null;
        if (method != null) {
            actionConfig = this.lookupActionConfig(actionPath + "#" + method);
        }
        if (actionConfig == null) {
            actionConfig = this.lookupActionConfig(actionPath);
        }
        return actionConfig;
    }

    protected void registerActionPath(String actionPath, String packageRoot) {
        String signature = this.mapActionPathToSignature(actionPath, packageRoot);
        try {
            this.actionsManager.register(signature, actionPath);
        }
        catch (MadvocException mex) {
            // empty catch block
        }
    }

    protected String mapActionPathToSignature(String actionPath, String packageRoot) {
        String className;
        int slashNdx;
        String httpMethod = MadvocUtil.extractHttpMethodFromActionPath(actionPath);
        if (httpMethod != null) {
            actionPath = actionPath.substring(0, actionPath.length() - httpMethod.length() - 1);
        }
        if ((slashNdx = actionPath.lastIndexOf(47)) > 0) {
            int start = actionPath.startsWith("/") ? 1 : 0;
            packageRoot = packageRoot + '.' + actionPath.substring(start, slashNdx).replace('/', '.');
        }
        String methodName = null;
        String extension = null;
        int dotNdx = actionPath.indexOf(46, slashNdx);
        if (dotNdx != -1) {
            className = actionPath.substring(slashNdx + 1, dotNdx);
            int extNdx = actionPath.indexOf(46, dotNdx + 1);
            if (extNdx != -1) {
                methodName = actionPath.substring(dotNdx + 1, extNdx);
                extension = actionPath.substring(extNdx + 1);
            } else {
                methodName = null;
                extension = actionPath.substring(dotNdx + 1);
            }
        } else {
            className = actionPath.substring(slashNdx + 1);
        }
        return this.buildSignature(packageRoot, className, methodName, extension, httpMethod);
    }

    protected String buildSignature(String packageName, String className, String methodName, String extension, String httpMethod) {
        if (methodName == null) {
            methodName = this.defaultMethodName1;
        }
        if (extension != null) {
            if (!this.madvocConfig.getDefaultExtension().equals(extension)) {
                methodName = methodName + StringUtil.capitalize((String)extension);
            }
        } else {
            methodName = this.defaultMethodName2;
        }
        return packageName + "." + StringUtil.capitalize((String)className) + "#" + methodName;
    }

    protected void registerSupplementAction(String actionPath) {
        if (this.madvocConfig.getSupplementAction() != null && actionPath.endsWith('.' + this.madvocConfig.getDefaultExtension())) {
            this.actionsManager.register(this.madvocConfig.getSupplementAction(), this.defaultMethodName1, actionPath);
        }
    }
}

