/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.component;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import jodd.introspector.ClassIntrospector;
import jodd.madvoc.ActionConfig;
import jodd.madvoc.MadvocException;
import jodd.madvoc.component.ActionMethodParser;
import jodd.madvoc.component.MadvocConfig;
import jodd.petite.meta.PetiteInject;
import jodd.util.ClassLoaderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionsManager {
    private static final Logger log = LoggerFactory.getLogger(ActionsManager.class);
    @PetiteInject
    protected ActionMethodParser actionMethodParser;
    @PetiteInject
    protected MadvocConfig madvocConfig;
    protected final Map<String, ActionConfig> configs = new HashMap<String, ActionConfig>();

    public Map<String, ActionConfig> getAllActionConfigurations() {
        return this.configs;
    }

    public void register(String actionSignature) {
        this.register(actionSignature, null);
    }

    public void register(String actionSignature, String actionPath) {
        Class actionClass;
        int ndx = actionSignature.indexOf(35);
        if (ndx == -1) {
            throw new MadvocException("Madvoc action signature syntax error: '" + actionSignature + "'.");
        }
        String actionClassName = actionSignature.substring(0, ndx);
        String actionMethodName = actionSignature.substring(ndx + 1);
        try {
            actionClass = ClassLoaderUtil.loadClass((String)actionClassName, this.getClass());
        }
        catch (ClassNotFoundException cnfex) {
            throw new MadvocException("Madvoc action class not found: '" + actionClassName + "'.", cnfex);
        }
        this.register(actionClass, actionMethodName, actionPath);
    }

    public void register(Class actionClass, String actionMethod) {
        this.register(actionClass, actionMethod, null);
    }

    public void register(Class actionClass, String actionMethod, String actionPath) {
        Method method = ClassIntrospector.lookup((Class)actionClass).getMethod(actionMethod);
        if (method == null) {
            throw new MadvocException("Provided action class '" + actionClass.getSimpleName() + "' doesn't contain public method '" + actionMethod + "'.");
        }
        this.registerAction(actionClass, method, actionPath);
    }

    public void register(Class actionClass, Method actionMethod, String actionPath) {
        this.registerAction(actionClass, actionMethod, actionPath);
    }

    public void register(Class actionClass, Method actionMethod) {
        this.registerAction(actionClass, actionMethod, null);
    }

    protected void registerAction(Class actionClass, Method actionMethod, String actionPath) {
        boolean isDuplicate;
        ActionConfig cfg = this.actionMethodParser.parse(actionClass, actionMethod, actionPath);
        if (cfg == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Registering Madvoc action: " + cfg.actionPath + " to: " + cfg.actionClass.getName() + '#' + cfg.actionMethod.getName());
        }
        boolean bl = isDuplicate = this.configs.put(cfg.actionPath, cfg) != null;
        if (this.madvocConfig.isDetectDuplicatePathsEnabled() && isDuplicate) {
            throw new MadvocException("Duplicated action path for '" + cfg + "'.");
        }
    }

    public ActionConfig lookup(String actionPath) {
        return this.configs.get(actionPath);
    }
}

