/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.component;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.madvoc.ActionConfig;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.MadvocException;
import jodd.madvoc.component.ActionPathMapper;
import jodd.madvoc.component.ActionPathRewriter;
import jodd.madvoc.component.ContextInjector;
import jodd.madvoc.component.InterceptorsManager;
import jodd.madvoc.component.MadvocConfig;
import jodd.madvoc.component.ResultMapper;
import jodd.madvoc.component.ResultsManager;
import jodd.madvoc.interceptor.ActionInterceptor;
import jodd.madvoc.result.ActionResult;
import jodd.petite.meta.PetiteInject;
import jodd.servlet.ServletUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MadvocController {
    private static final Logger log = LoggerFactory.getLogger(MadvocController.class);
    @PetiteInject
    protected MadvocConfig madvocConfig;
    @PetiteInject
    protected ActionPathMapper actionPathMapper;
    @PetiteInject
    protected ActionPathRewriter actionPathRewriter;
    @PetiteInject
    protected InterceptorsManager interceptorsManager;
    @PetiteInject
    protected ContextInjector contextInjector;
    @PetiteInject
    protected ResultsManager resultsManager;
    @PetiteInject
    protected ResultMapper resultMapper;
    protected ServletContext applicationContext;

    public void init(ServletContext servletContext) {
        this.applicationContext = servletContext;
    }

    public ServletContext getApplicationContext() {
        return this.applicationContext;
    }

    public String invoke(String actionPath, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws Exception {
        ActionRequest request = null;
        String encoding = this.madvocConfig.getEncoding();
        if (encoding != null) {
            servletRequest.setCharacterEncoding(this.madvocConfig.getEncoding());
            servletResponse.setCharacterEncoding(this.madvocConfig.getEncoding());
        }
        while (actionPath != null) {
            log.debug("Action path: {}", (Object)actionPath);
            String httpMethod = servletRequest.getMethod().toUpperCase();
            actionPath = this.actionPathRewriter.rewrite(actionPath, servletRequest, httpMethod);
            ActionConfig actionConfig = this.resolveActionConfig(actionPath, httpMethod);
            if (actionConfig == null) {
                return actionPath;
            }
            if (log.isDebugEnabled()) {
                log.debug("Invoking action path {} using {}", (Object)actionPath, (Object)actionConfig.actionClass.getSimpleName());
            }
            Object action = this.createAction(actionConfig.actionClass);
            ActionRequest previousRequest = request;
            request = this.createActionRequest(actionConfig, action, servletRequest, servletResponse);
            request.setPreviousActionRequest(previousRequest);
            this.invokeAndRender(request);
            actionPath = request.getNextActionPath();
        }
        return null;
    }

    protected void invokeAndRender(ActionRequest request) throws Exception {
        Object resultValueObject = request.invoke();
        this.render(request, resultValueObject);
    }

    public void render(ActionRequest req, Object resultObject) throws Exception {
        ActionResult result;
        int columnIndex;
        String resultValue = resultObject != null ? resultObject.toString() : null;
        String resultType = this.madvocConfig.getDefaultResultType();
        if (resultValue != null && (columnIndex = resultValue.indexOf(58)) != -1) {
            resultType = resultValue.substring(0, columnIndex);
            resultValue = resultValue.substring(columnIndex + 1);
        }
        if ((result = this.resultsManager.lookup(resultType)) == null) {
            throw new MadvocException("Unable to find action result type '" + resultType + "'.");
        }
        if (!result.isInitialized()) {
            this.contextInjector.injectContext(result, req.getHttpServletRequest(), req.getHttpServletResponse());
            result.initialized();
            result.init();
        }
        if (this.madvocConfig.isPreventCaching()) {
            ServletUtil.preventCaching((HttpServletResponse)req.getHttpServletResponse());
        }
        String resultPath = this.resultMapper.resolveResultPath(req.getActionConfig(), resultValue);
        result.render(req, resultObject, resultValue, resultPath);
    }

    protected ActionConfig resolveActionConfig(String actionPath, String httpMethod) {
        ActionConfig actionConfig = this.actionPathMapper.resolveActionConfig(actionPath, httpMethod);
        if (actionConfig != null && !actionConfig.initialized) {
            this.initializeActionConfig(actionConfig);
        }
        return actionConfig;
    }

    protected void initializeActionConfig(ActionConfig cfg) {
        Class<? extends ActionInterceptor>[] interceptorClasses = cfg.interceptorClasses;
        if (interceptorClasses == null) {
            interceptorClasses = this.madvocConfig.getDefaultInterceptors();
        }
        for (ActionInterceptor interceptor : cfg.interceptors = this.interceptorsManager.resolveAll(interceptorClasses)) {
            if (interceptor.isInitialized()) continue;
            this.contextInjector.injectContext(interceptor, this.applicationContext);
            interceptor.initialized();
            interceptor.init();
        }
        cfg.initialized();
    }

    protected Object createAction(Class actionClass) {
        try {
            return actionClass.newInstance();
        }
        catch (InstantiationException iex) {
            throw new MadvocException("Unable to create Madvoc action.", iex);
        }
        catch (IllegalAccessException iaex) {
            throw new MadvocException("Not enough rights to create Madvoc action.", iaex);
        }
    }

    protected ActionRequest createActionRequest(ActionConfig actionConfig, Object action, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        return new ActionRequest(actionConfig, action, servletRequest, servletResponse);
    }
}

