/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.config;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.io.findfile.FindClass;
import jodd.madvoc.MadvocException;
import jodd.madvoc.component.ActionsManager;
import jodd.madvoc.component.ResultsManager;
import jodd.madvoc.config.MadvocConfigurator;
import jodd.madvoc.meta.Action;
import jodd.madvoc.meta.MadvocAction;
import jodd.madvoc.result.ActionResult;
import jodd.petite.meta.PetiteInject;
import jodd.util.ClassLoaderUtil;
import jodd.util.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutomagicMadvocConfigurator
extends FindClass
implements MadvocConfigurator {
    private static final Logger log = LoggerFactory.getLogger(AutomagicMadvocConfigurator.class);
    @PetiteInject
    protected ActionsManager actionsManager;
    @PetiteInject
    protected ResultsManager resultsManager;
    protected String actionClassSuffix = "Action";
    protected String resultClassSuffix = "Result";
    protected long elapsed = 0L;

    public void configure() {
        this.configure(ClassLoaderUtil.getFullClassPath(AutomagicMadvocConfigurator.class));
    }

    public void configure(URL[] classpath) {
        this.elapsed = System.currentTimeMillis();
        try {
            this.scanUrls(classpath);
        }
        catch (Exception ex) {
            throw new MadvocException("Unable to scan classpath.", ex);
        }
        this.elapsed = System.currentTimeMillis() - this.elapsed;
        log.info("Madvoc configured in " + this.elapsed + " ms. Total actions: " + this.actionsManager.getAllActionConfigurations().size());
    }

    protected void onEntry(FindClass.EntryData entryData) {
        String entryName = entryData.getName();
        if (entryName.endsWith(this.actionClassSuffix)) {
            try {
                this.onActionClass(entryName);
            }
            catch (ClassNotFoundException cnfex) {
                throw new MadvocException("Unable to load Madvoc action class: " + entryName, cnfex);
            }
        }
        if (entryName.endsWith(this.resultClassSuffix)) {
            try {
                this.onResultClass(entryName);
            }
            catch (ClassNotFoundException cnfex) {
                throw new MadvocException("Unable to load Madvoc result class: " + entryName, cnfex);
            }
        }
    }

    public boolean checkClass(Class clazz) {
        return !clazz.isAnonymousClass() && !clazz.isArray() && !clazz.isEnum() && !clazz.isInterface() && !clazz.isLocalClass() && !(clazz.isMemberClass() ^ Modifier.isStatic(clazz.getModifiers())) && !clazz.isPrimitive();
    }

    protected void onActionClass(String className) throws ClassNotFoundException {
        Method[] allPublicMethods;
        Class actionClass = ClassLoaderUtil.loadClass((String)className, this.getClass());
        if (!this.checkClass(actionClass)) {
            return;
        }
        if (actionClass.getAnnotation(MadvocAction.class) == null && actionClass.getSuperclass().getAnnotation(MadvocAction.class) == null) {
            return;
        }
        ClassDescriptor cd = ClassIntrospector.lookup((Class)actionClass);
        for (Method method : allPublicMethods = cd.getAllMethods()) {
            if (method.getAnnotation(Action.class) == null) continue;
            this.actionsManager.register(actionClass, method);
        }
    }

    protected void onResultClass(String className) throws ClassNotFoundException {
        Class resultClass = ClassLoaderUtil.loadClass((String)className, this.getClass());
        if (resultClass.equals(ActionResult.class)) {
            return;
        }
        if (ReflectUtil.isSubclass((Class)resultClass, ActionResult.class)) {
            this.resultsManager.register(resultClass);
        }
    }
}

