/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.interceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.ScopeType;
import jodd.madvoc.component.ContextInjector;
import jodd.madvoc.component.MadvocConfig;
import jodd.madvoc.injector.ApplicationScopeInjector;
import jodd.madvoc.injector.MadvocContextScopeInjector;
import jodd.madvoc.injector.RequestScopeInjector;
import jodd.madvoc.injector.ServletContextScopeInjector;
import jodd.madvoc.injector.SessionScopeInjector;
import jodd.madvoc.interceptor.ActionInterceptor;
import jodd.madvoc.meta.In;
import jodd.servlet.ServletUtil;
import jodd.servlet.upload.MultipartRequestWrapper;

public class ServletConfigInterceptor
extends ActionInterceptor {
    @In(scope=ScopeType.CONTEXT)
    protected MadvocConfig madvocConfig;
    @In(scope=ScopeType.CONTEXT)
    protected ContextInjector contextInjector;
    protected RequestScopeInjector requestScopeInjector;
    protected SessionScopeInjector sessionScopeInjector;
    protected ApplicationScopeInjector applicationScopeInjector;
    protected MadvocContextScopeInjector madvocContextScopeInjector;
    protected ServletContextScopeInjector servletContextScopeInjector;

    public void init() {
        this.requestScopeInjector = new RequestScopeInjector(this.madvocConfig);
        this.sessionScopeInjector = new SessionScopeInjector();
        this.applicationScopeInjector = this.contextInjector.getApplicationScopeInjector();
        this.madvocContextScopeInjector = this.contextInjector.getMadvocContextScopeInjector();
        this.servletContextScopeInjector = this.contextInjector.getServletContextScopeInjector();
    }

    public Object intercept(ActionRequest actionRequest) throws Exception {
        HttpServletRequest servletRequest = actionRequest.getHttpServletRequest();
        HttpServletResponse serlvetResponse = actionRequest.getHttpServletResponse();
        if (ServletUtil.isMultipartRequest((HttpServletRequest)servletRequest)) {
            servletRequest = new MultipartRequestWrapper(servletRequest, this.madvocConfig.getFileUploadFactory(), this.madvocConfig.getEncoding());
            actionRequest.setHttpServletRequest(servletRequest);
        }
        Object target = actionRequest.getAction();
        this.inject(target, servletRequest, serlvetResponse);
        Object result = actionRequest.invoke();
        this.outject(target, servletRequest, serlvetResponse);
        return result;
    }

    protected void inject(Object target, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        this.servletContextScopeInjector.inject(target, servletRequest, servletResponse);
        this.madvocContextScopeInjector.inject(target);
        this.applicationScopeInjector.inject(target, servletRequest.getSession().getServletContext());
        this.sessionScopeInjector.inject(target, servletRequest);
        this.requestScopeInjector.prepare(servletRequest);
        this.requestScopeInjector.inject(target, servletRequest);
    }

    protected void outject(Object target, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        this.servletContextScopeInjector.outject(target, servletResponse);
        this.madvocContextScopeInjector.outject(target);
        this.applicationScopeInjector.outject(target, servletRequest.getSession().getServletContext());
        this.sessionScopeInjector.outject(target, servletRequest);
        this.requestScopeInjector.outject(target, servletRequest);
    }
}

