/*
 * Decompiled with CFR 0.152.
 */
package jodd.paramo;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import jodd.asm.EmptyClassVisitor;
import jodd.paramo.ParamExtractor;
import jodd.paramo.ParamoException;
import jodd.util.StringUtil;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

final class MethodFinder
extends EmptyClassVisitor {
    public static final String[] EMPTY_NAMES = new String[0];
    private static final Map<String, String> primitives = new HashMap<String, String>(7);
    final String methodName;
    final Class[] parameterTypes;
    ParamExtractor paramExtractor;

    MethodFinder(String methodName, Class[] parameterTypes) {
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
        this.paramExtractor = null;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.paramExtractor != null) {
            return null;
        }
        if (!name.equals(this.methodName)) {
            return null;
        }
        Type[] argumentTypes = Type.getArgumentTypes((String)desc);
        int dwordsCount = 0;
        for (Type t : argumentTypes) {
            if (!t.getClassName().equals("long") && !t.getClassName().equals("double")) continue;
            ++dwordsCount;
        }
        int paramCount = argumentTypes.length;
        if (paramCount != this.parameterTypes.length) {
            return null;
        }
        for (int i = 0; i < argumentTypes.length; ++i) {
            if (this.isEqualTypeName(argumentTypes[i], this.parameterTypes[i])) continue;
            return null;
        }
        this.paramExtractor = new ParamExtractor(Modifier.isStatic(access) ? 0 : 1, argumentTypes.length + dwordsCount);
        return this.paramExtractor;
    }

    boolean isEqualTypeName(Type argumentType, Class paramType) {
        String s = argumentType.getClassName();
        if (s.endsWith("[]")) {
            String prefix = s.substring(0, s.length() - 2);
            String bytecodeSymbol = primitives.get(prefix);
            s = bytecodeSymbol != null ? '[' + bytecodeSymbol : "[L" + prefix + ';';
        }
        return s.equals(paramType.getName());
    }

    String[] getParameterNames() {
        if (this.paramExtractor == null) {
            return EMPTY_NAMES;
        }
        if (!this.paramExtractor.debugInfoPresent) {
            throw new ParamoException("Parameter names not availiable for '" + this.methodName + "'.");
        }
        return StringUtil.splitc((String)this.paramExtractor.getResult(), (char)',');
    }

    static {
        primitives.put("int", "I");
        primitives.put("boolean", "Z");
        primitives.put("char", "C");
        primitives.put("short", "B");
        primitives.put("float", "F");
        primitives.put("long", "J");
        primitives.put("double", "D");
    }
}

