/*
 * Decompiled with CFR 0.152.
 */
package jodd.paramo;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import jodd.paramo.MethodFinder;
import jodd.paramo.ParamoException;
import jodd.util.ClassLoaderUtil;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class Paramo {
    protected static final String CTOR_METHOD = "<init>";

    public static String[] resolveParameterNames(AccessibleObject methodOrCtor) {
        InputStream stream;
        Class<Object> declaringClass;
        String name;
        Class[] paramTypes;
        if (methodOrCtor instanceof Method) {
            Method method = (Method)methodOrCtor;
            paramTypes = method.getParameterTypes();
            name = method.getName();
            declaringClass = method.getDeclaringClass();
        } else {
            Constructor constructor = (Constructor)methodOrCtor;
            paramTypes = constructor.getParameterTypes();
            declaringClass = constructor.getDeclaringClass();
            name = CTOR_METHOD;
        }
        if (paramTypes.length == 0) {
            return MethodFinder.EMPTY_NAMES;
        }
        try {
            stream = ClassLoaderUtil.getClassAsStream(declaringClass);
        }
        catch (IOException ioex) {
            throw new ParamoException("Unable to read class bytes.");
        }
        try {
            ClassReader reader = new ClassReader(stream);
            MethodFinder visitor = new MethodFinder(name, paramTypes);
            reader.accept((ClassVisitor)visitor, 0);
            return visitor.getParameterNames();
        }
        catch (IOException ioex) {
            throw new ParamoException(ioex);
        }
    }
}

