/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite.manager;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.petite.CtorInjectionPoint;
import jodd.petite.PetiteException;
import jodd.petite.PetiteUtil;
import jodd.petite.meta.PetiteInject;

public class CtorResolver {
    protected Map<Class, CtorInjectionPoint> ctors = new HashMap<Class, CtorInjectionPoint>();
    protected static final String[] EMPTY_STRING = new String[0];

    public CtorInjectionPoint resolve(Class type) {
        return this.resolve(type, true);
    }

    public CtorInjectionPoint resolveDefault(Class type) {
        return this.resolve(type, false);
    }

    protected CtorInjectionPoint resolve(Class type, boolean useAnnotation) {
        CtorInjectionPoint cip = this.ctors.get(type);
        if (cip != null) {
            return cip;
        }
        ClassDescriptor cd = ClassIntrospector.lookup((Class)type);
        Constructor[] allCtors = cd.getAllCtors(true);
        Constructor foundedCtor = null;
        Constructor defaultCtor = null;
        String[] refNames = null;
        for (Constructor ctor : allCtors) {
            PetiteInject ref;
            Class<?>[] paramTypes = ctor.getParameterTypes();
            if (paramTypes.length == 0) {
                defaultCtor = ctor;
            }
            if (!useAnnotation || (ref = ctor.getAnnotation(PetiteInject.class)) == null) continue;
            if (foundedCtor != null) {
                throw new PetiteException("Two or more constructors are annotated as injection points in bean: " + type.getName());
            }
            refNames = PetiteUtil.resolveParamReferences(ref.value(), paramTypes);
            if (refNames.length != paramTypes.length) {
                throw new PetiteException("Invalid number of constructor argument reference names for '" + type.getName() + '\'');
            }
            foundedCtor = ctor;
        }
        if (foundedCtor == null) {
            foundedCtor = allCtors.length == 1 ? allCtors[0] : defaultCtor;
        }
        if (foundedCtor == null) {
            throw new PetiteException("No constructor (annotated, single or default) founded as injection point for '" + type.getName() + '\'');
        }
        if (refNames == null) {
            refNames = PetiteUtil.resolveParamReferences(foundedCtor.getParameterTypes());
        }
        cip = new CtorInjectionPoint(foundedCtor, refNames);
        this.ctors.put(type, cip);
        return cip;
    }
}

