/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite.manager;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.petite.BeanDefinition;
import jodd.petite.CtorInjectionPoint;
import jodd.petite.InitMethodPoint;
import jodd.petite.MethodInjectionPoint;
import jodd.petite.PetiteConfig;
import jodd.petite.PetiteException;
import jodd.petite.PetiteUtil;
import jodd.petite.PropertyInjectionPoint;
import jodd.petite.WiringMode;
import jodd.petite.manager.BeanManager;
import jodd.petite.manager.CtorResolver;
import jodd.petite.manager.InitMethodResolver;
import jodd.petite.manager.MethodResolver;
import jodd.petite.manager.ParamResolver;
import jodd.petite.manager.PropertyResolver;
import jodd.petite.scope.DefaultScope;
import jodd.petite.scope.Scope;
import jodd.util.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PetiteManager {
    private static final Logger log = LoggerFactory.getLogger(PetiteManager.class);
    protected final BeanManager beanManager = new BeanManager();
    protected final CtorResolver ctorResolver = new CtorResolver();
    protected final PropertyResolver propertyResolver = new PropertyResolver();
    protected final MethodResolver methodResolver = new MethodResolver();
    protected final InitMethodResolver initMethodResolver = new InitMethodResolver();
    protected final ParamResolver paramResolver = new ParamResolver();

    public BeanDefinition lookupBeanDefinition(String name) {
        return this.beanManager.beans.get(name);
    }

    public BeanDefinition registerBean(String name, Class type, Class<? extends Scope> scopeType, WiringMode wiringMode, PetiteConfig pcfg) {
        BeanDefinition existing;
        if (name == null) {
            name = PetiteUtil.resolveBeanName(type);
        }
        if (wiringMode == null) {
            wiringMode = PetiteUtil.resolveBeanWiringMode(type);
        }
        if (wiringMode == WiringMode.DEFAULT) {
            wiringMode = pcfg.getDefaultWiringMode();
        }
        if (scopeType == null) {
            scopeType = PetiteUtil.resolveBeanScopeType(type);
        }
        if (scopeType == DefaultScope.class) {
            scopeType = pcfg.getDefaultScope();
        }
        if ((existing = this.removeBean(name)) != null && pcfg.getDetectDuplicatedBeanNames()) {
            throw new PetiteException("Duplicated bean name detected while registering class '" + type.getName() + "'. Petite bean class '" + existing.type.getName() + "' is already registered with the name '" + name + "'.");
        }
        if (log.isDebugEnabled()) {
            log.debug("Registering bean: " + name + " of type: " + type.getSimpleName() + " in: " + scopeType.getSimpleName() + " using wiring mode: " + wiringMode.toString());
        }
        return this.beanManager.register(name, type, scopeType, wiringMode);
    }

    public BeanDefinition removeBean(String name) {
        BeanDefinition bd = this.beanManager.beans.remove(name);
        if (bd == null) {
            return null;
        }
        this.ctorResolver.ctors.remove(bd.type);
        this.propertyResolver.properties.remove(bd.type);
        this.methodResolver.methodRefs.remove(bd.type);
        this.initMethodResolver.initMethods.remove(bd.type);
        bd.scopeRemove();
        return bd;
    }

    public int getTotalBeans() {
        return this.beanManager.beans.size();
    }

    public int getTotalScopes() {
        return this.beanManager.scopes.size();
    }

    public Iterator<BeanDefinition> beansIterator() {
        return this.beanManager.beans.values().iterator();
    }

    public void registerScope(Class<? extends Scope> scopeType, Scope scope) {
        this.beanManager.registerScope(scopeType, scope);
    }

    public CtorInjectionPoint resolveCtorInjectionPoint(Class type) {
        return this.ctorResolver.resolve(type);
    }

    public CtorInjectionPoint resolveDefaultCtorInjectionPoint(Class type) {
        return this.ctorResolver.resolveDefault(type);
    }

    public CtorInjectionPoint defineCtorInjectionPoint(Class type, Class[] paramTypes, String[] references) {
        ClassDescriptor cd = ClassIntrospector.lookup((Class)type);
        Constructor constructor = null;
        if (paramTypes == null) {
            Constructor[] ctors = cd.getAllCtors(true);
            if (ctors.length > 0) {
                if (ctors.length > 1) {
                    throw new PetiteException(ctors.length + " suitable constructor found as injection point for: '" + type.getName() + "'.");
                }
                constructor = ctors[0];
                paramTypes = constructor.getParameterTypes();
            }
        } else {
            constructor = cd.getCtor(paramTypes, true);
        }
        if (constructor == null) {
            throw new PetiteException("Constructor '" + type.getName() + "()' not found.");
        }
        if (references == null) {
            references = PetiteUtil.resolveParamReferences(paramTypes);
        } else if (paramTypes.length != references.length) {
            throw new PetiteException("Different number of ctor parameters and references for: '" + constructor.getName() + "'.");
        }
        return new CtorInjectionPoint(constructor, references);
    }

    public PropertyInjectionPoint[] resolvePropertyInjectionPoint(Class type) {
        return this.propertyResolver.resolve(type);
    }

    public PropertyInjectionPoint definePropertyInjectionPoint(Class type, String property, String reference) {
        ClassDescriptor cd;
        Field field;
        if (reference == null) {
            reference = property;
        }
        if ((field = (cd = ClassIntrospector.lookup((Class)type)).getField(property, true)) == null) {
            throw new PetiteException("Property '" + type.getName() + '#' + property + "' doesn't exist");
        }
        return new PropertyInjectionPoint(field, reference, true);
    }

    public MethodInjectionPoint[] resolveMethodInjectionPoint(Class type) {
        return this.methodResolver.resolve(type);
    }

    public MethodInjectionPoint defineMethodInjectionPoint(Class type, String methodName, Class[] paramTypes, String[] references) {
        ClassDescriptor cd = ClassIntrospector.lookup((Class)type);
        Method method = null;
        if (paramTypes == null) {
            Method[] methods = cd.getAllMethods(methodName, true);
            if (methods.length > 0) {
                if (methods.length > 1) {
                    throw new PetiteException(methods.length + " suitable methods found as injection points for '" + type.getName() + '#' + methodName + "()'.");
                }
                method = methods[0];
                paramTypes = method.getParameterTypes();
            }
        } else {
            method = cd.getMethod(methodName, paramTypes, true);
        }
        if (method == null) {
            throw new PetiteException("Method '" + type.getName() + '#' + methodName + "()' not found.");
        }
        if (references == null) {
            references = PetiteUtil.resolveParamReferences(paramTypes);
        } else if (paramTypes.length != references.length) {
            throw new PetiteException("Different number of method parameters and references for: '" + type.getName() + '#' + methodName + "()'.");
        }
        return new MethodInjectionPoint(method, references);
    }

    public InitMethodPoint[] resolveInitMethods(Object bean) {
        return this.initMethodResolver.resolve(bean);
    }

    public InitMethodPoint[] defineInitMethods(Class type, String[] methodNames) {
        return this.defineInitMethods(type, null, methodNames);
    }

    public InitMethodPoint[] defineInitMethods(Class type, String[] beforeMethodNames, String[] afterMethodNames) {
        int i;
        ClassDescriptor cd = ClassIntrospector.lookup((Class)type);
        if (beforeMethodNames == null) {
            beforeMethodNames = new String[]{};
        }
        if (afterMethodNames == null) {
            afterMethodNames = new String[]{};
        }
        int total = beforeMethodNames.length + afterMethodNames.length;
        InitMethodPoint[] methods = new InitMethodPoint[total];
        for (i = 0; i < beforeMethodNames.length; ++i) {
            Method m = cd.getMethod(beforeMethodNames[i], ReflectUtil.NO_PARAMETERS, true);
            if (m == null) {
                throw new PetiteException("Init method '" + type.getName() + '#' + beforeMethodNames[i] + "()' not found.");
            }
            methods[i] = new InitMethodPoint(m, i, true);
        }
        for (int j = 0; j < afterMethodNames.length; ++j) {
            Method m = cd.getMethod(afterMethodNames[j], ReflectUtil.NO_PARAMETERS, true);
            if (m == null) {
                throw new PetiteException("Init method '" + type.getName() + '#' + afterMethodNames[j] + "()' not found.");
            }
            methods[i + j] = new InitMethodPoint(m, i + j, true);
        }
        return methods;
    }

    public void defineParameter(String name, Object value) {
        this.paramResolver.put(name, value);
    }

    public Object getParameter(String name) {
        return this.paramResolver.get(name);
    }

    public String[] resolveBeanParams(String name, boolean resolveReferenceParams) {
        return this.paramResolver.resolve(name, resolveReferenceParams);
    }
}

