/*
 * Decompiled with CFR 0.152.
 */
package jodd.proxetta.asm;

import java.io.IOException;
import java.io.InputStream;
import jodd.io.StreamUtil;
import jodd.proxetta.ProxettaException;
import jodd.proxetta.ProxyAspect;
import jodd.proxetta.asm.ProxettaClassBuilder;
import jodd.proxetta.asm.TargetClassInfoReader;
import jodd.util.ClassLoaderUtil;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxettaCreator {
    private static final Logger log = LoggerFactory.getLogger(ProxettaCreator.class);
    protected final ProxyAspect[] aspects;
    protected static int suffixCounter;
    protected boolean useSuffix;
    protected String classNameSuffix;
    protected ClassWriter destClassWriter;
    protected boolean proxyApplied;
    protected String proxyClassName;

    public ProxettaCreator(ProxyAspect ... aspects) {
        this.aspects = aspects;
    }

    public void setUseVariableClassName(boolean useVariableClassName) {
        this.useSuffix = useVariableClassName;
    }

    public void setClassNameSuffix(String classNameSuffix) {
        this.classNameSuffix = classNameSuffix;
    }

    protected String classNameSuffix() {
        if (!this.useSuffix) {
            return this.classNameSuffix;
        }
        return this.classNameSuffix + ++suffixCounter;
    }

    protected ProxettaCreator accept(ClassReader cr, String reqProxyClassName) {
        if (log.isDebugEnabled()) {
            log.debug("Creating proxy for " + cr.getClassName());
        }
        TargetClassInfoReader targetClassInfoReader = new TargetClassInfoReader();
        cr.accept((ClassVisitor)targetClassInfoReader, 0);
        this.destClassWriter = new ClassWriter(3);
        ProxettaClassBuilder pcb = new ProxettaClassBuilder((ClassVisitor)this.destClassWriter, this.aspects, this.classNameSuffix(), reqProxyClassName, targetClassInfoReader);
        cr.accept((ClassVisitor)pcb, 0);
        this.proxyApplied = pcb.wd.proxyApplied;
        this.proxyClassName = pcb.wd.thisReference.replace('/', '.');
        return this;
    }

    public ProxettaCreator accept(InputStream in, String reqProxyClassName) {
        ClassReader cr;
        try {
            cr = new ClassReader(in);
        }
        catch (IOException ioex) {
            throw new ProxettaException("Error reading class input stream.", ioex);
        }
        return this.accept(cr, reqProxyClassName);
    }

    public ProxettaCreator accept(String targetName, String reqProxyClassName) {
        InputStream inputStream = null;
        try {
            inputStream = ClassLoaderUtil.getClassAsStream((String)targetName);
            ProxettaCreator proxettaCreator = this.accept(inputStream, reqProxyClassName);
            return proxettaCreator;
        }
        catch (IOException ioex) {
            throw new ProxettaException("Unable to open stream for class name: " + targetName, ioex);
        }
        finally {
            StreamUtil.close((InputStream)inputStream);
        }
    }

    public ProxettaCreator accept(Class target, String reqProxyClassName) {
        InputStream inputStream = null;
        try {
            inputStream = ClassLoaderUtil.getClassAsStream((Class)target);
            ProxettaCreator proxettaCreator = this.accept(inputStream, reqProxyClassName);
            return proxettaCreator;
        }
        catch (IOException ioex) {
            throw new ProxettaException("Unable to open stream for: " + target.getName(), ioex);
        }
        finally {
            StreamUtil.close((InputStream)inputStream);
        }
    }

    protected void checkAccepted() {
        if (this.destClassWriter == null) {
            throw new ProxettaException("Target not accepted yet!");
        }
    }

    public byte[] toByteArray() {
        this.checkAccepted();
        return this.destClassWriter.toByteArray();
    }

    public boolean isProxyApplied() {
        this.checkAccepted();
        return this.proxyApplied;
    }

    public String getProxyClassName() {
        this.checkAccepted();
        return this.proxyClassName;
    }
}

